/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.configure;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarBinarySpecInitializer
implements Action<JarBinarySpec> {
    private final File binariesDir;
    private final File classesDir;

    public JarBinarySpecInitializer(File buildDir) {
        this.binariesDir = new File(buildDir, "jars");
        this.classesDir = new File(buildDir, "classes");
    }

    public void execute(JarBinarySpec jarBinarySpec) {
        JarBinarySpecInternal jarBinarySpecInternal = (JarBinarySpecInternal)jarBinarySpec;
        String outputBaseName = jarBinarySpecInternal.getNamingScheme().getOutputDirectoryBase();
        File outputDir = new File(this.classesDir, outputBaseName);
        jarBinarySpec.setClassesDir(outputDir);
        jarBinarySpec.setResourcesDir(outputDir);
        jarBinarySpec.setJarFile(new File(this.binariesDir, String.format("%s/%s.jar", outputBaseName, jarBinarySpecInternal.getLibrary().getName())));
    }
}

