/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.configure;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.configure.JarBinariesFactory;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmLibrarySpecInitializer
implements Action<JvmLibrarySpec> {
    private final JarBinariesFactory factory;
    private final BinaryNamingSchemeBuilder namingSchemeBuilder;
    private final JavaToolChainRegistry toolChains;
    private final PlatformContainer platforms;

    public JvmLibrarySpecInitializer(JarBinariesFactory factory, BinaryNamingSchemeBuilder namingSchemeBuilder, JavaToolChainRegistry toolChains, PlatformContainer platforms) {
        this.factory = factory;
        this.namingSchemeBuilder = namingSchemeBuilder;
        this.toolChains = toolChains;
        this.platforms = platforms;
    }

    public void execute(JvmLibrarySpec jvmLibrary) {
        List<String> targetPlatforms = jvmLibrary.getTargetPlatforms();
        if (targetPlatforms.isEmpty()) {
            targetPlatforms = Collections.singletonList(new DefaultJavaPlatform(JavaVersion.current()).getName());
        }
        List selectedPlatforms = this.platforms.select(JavaPlatform.class, (List)targetPlatforms);
        for (JavaPlatform platform : selectedPlatforms) {
            JavaToolChain toolChain = (JavaToolChain)this.toolChains.getForPlatform(platform);
            BinaryNamingSchemeBuilder componentBuilder = this.namingSchemeBuilder.withComponentName(jvmLibrary.getName()).withTypeString("jar");
            if (selectedPlatforms.size() > 1) {
                componentBuilder = componentBuilder.withVariantDimension(platform.getName());
            }
            BinaryNamingScheme namingScheme = componentBuilder.build();
            this.factory.createJarBinaries(jvmLibrary, namingScheme, toolChain, platform);
        }
    }
}

