/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.configure.DefaultJarBinariesFactory;
import org.gradle.jvm.internal.configure.JarBinarySpecInitializer;
import org.gradle.jvm.internal.configure.JvmLibrarySpecInitializer;
import org.gradle.jvm.internal.plugins.DefaultJvmComponentExtension;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolChainRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        ComponentSpecContainer componentSpecs = (ComponentSpecContainer)project.getExtensions().getByType(ComponentSpecContainer.class);
        final ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        componentSpecs.registerFactory(JvmLibrarySpec.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<JvmLibrarySpec>(){

            public JvmLibrarySpec create(String name) {
                DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(project.getPath(), name);
                return new DefaultJvmLibrarySpec((ComponentSpecIdentifier)id, (FunctionalSourceSet)sources.maybeCreate(name));
            }
        });
        NamedDomainObjectContainer jvmLibraries = componentSpecs.containerWithType(JvmLibrarySpec.class);
        project.getExtensions().create("jvm", DefaultJvmComponentExtension.class, new Object[]{jvmLibraries});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkBinariesBuildable
    implements Action<JarBinarySpec> {
        private MarkBinariesBuildable() {
        }

        public void execute(JarBinarySpec jarBinarySpec) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)jarBinarySpec.getToolChain();
            boolean canBuild = toolChain.select(jarBinarySpec.getTargetPlatform()).isAvailable();
            ((JarBinarySpecInternal)jarBinarySpec).setBuildable(canBuild);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    public static class Rules {
        @Model
        NamedDomainObjectCollection<JvmLibrarySpec> jvmLibraries(ComponentSpecContainer components) {
            return components.withType(JvmLibrarySpec.class);
        }

        @Model
        BinaryNamingSchemeBuilder binaryNamingSchemeBuilder() {
            return new DefaultBinaryNamingSchemeBuilder();
        }

        @Model
        JavaToolChainRegistry javaToolChain(ServiceRegistry serviceRegistry) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)serviceRegistry.get(JavaToolChainInternal.class);
            return new DefaultJavaToolChainRegistry(toolChain);
        }

        @Mutate
        public void registerJavaPlatformType(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            platforms.registerFactory(JavaPlatform.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<JavaPlatform>(){

                public JavaPlatform create(String name) {
                    return (JavaPlatform)instantiator.newInstance(DefaultJavaPlatform.class, new Object[]{name});
                }
            });
        }

        @Mutate
        public void createJavaPlatforms(PlatformContainer platforms, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            for (JavaVersion javaVersion : JavaVersion.values()) {
                DefaultJavaPlatform javaPlatform = (DefaultJavaPlatform)instantiator.newInstance(DefaultJavaPlatform.class, new Object[]{javaVersion});
                platforms.add((Object)javaPlatform);
            }
        }

        @Mutate
        public void createBinaries(BinaryContainer binaries, PlatformContainer platforms, BinaryNamingSchemeBuilder namingSchemeBuilder, NamedDomainObjectCollection<JvmLibrarySpec> libraries, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry, JavaToolChainRegistry toolChains) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            ArrayList actions = Lists.newArrayList();
            actions.add(new JarBinarySpecInitializer(buildDir));
            actions.add(new MarkBinariesBuildable());
            Action initAction = Actions.composite((Iterable)actions);
            DefaultJarBinariesFactory factory = new DefaultJarBinariesFactory(instantiator, (Action<? super JarBinarySpec>)initAction);
            JvmLibrarySpecInitializer createBinariesAction = new JvmLibrarySpecInitializer(factory, namingSchemeBuilder, toolChains, platforms);
            for (JvmLibrarySpec jvmLibrary : libraries) {
                createBinariesAction.execute(jvmLibrary);
                binaries.addAll((Collection)jvmLibrary.getBinaries());
            }
        }

        @Mutate
        public void createTasks(TaskContainer tasks, BinaryContainer binaries) {
            for (JarBinarySpecInternal projectJarBinary : binaries.withType(JarBinarySpecInternal.class)) {
                Task jarTask = this.createJarTask(tasks, projectJarBinary);
                projectJarBinary.builtBy(new Object[]{jarTask});
                projectJarBinary.getTasks().add(jarTask);
            }
        }

        private Task createJarTask(TaskContainer tasks, JarBinarySpecInternal binary) {
            Jar jar = (Jar)tasks.create(binary.getNamingScheme().getTaskName("create"), Jar.class);
            jar.setDescription(String.format("Creates the binary file for %s.", binary.getNamingScheme().getDescription()));
            jar.from(new Object[]{binary.getClassesDir()});
            jar.from(new Object[]{binary.getResourcesDir()});
            jar.setDestinationDir(binary.getJarFile().getParentFile());
            jar.setArchiveName(binary.getJarFile().getName());
            return jar;
        }
    }
}

