/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.reporting.components.ComponentReport;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.ProjectReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.configuration.Help;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class HelpTasksPlugin
implements Plugin<ProjectInternal> {
    public static final String HELP_GROUP = "help";
    public static final String PROPERTIES_TASK = "properties";
    public static final String DEPENDENCIES_TASK = "dependencies";
    public static final String DEPENDENCY_INSIGHT_TASK = "dependencyInsight";
    public static final String COMPONENTS_TASK = "components";

    public void apply(final ProjectInternal project) {
        final TaskContainerInternal tasks = project.getTasks();
        tasks.addPlaceholderAction(HELP_GROUP, new Runnable(){

            public void run() {
                tasks.create(HelpTasksPlugin.HELP_GROUP, Help.class, (Action)new Action<Help>(){

                    public void execute(Help task) {
                        task.setDescription("Displays a help message.");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
        tasks.addPlaceholderAction("projects", new Runnable(){

            public void run() {
                tasks.create("projects", ProjectReportTask.class, (Action)new Action<ProjectReportTask>(){

                    public void execute(ProjectReportTask task) {
                        task.setDescription("Displays the sub-projects of " + project + ".");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
        tasks.addPlaceholderAction("tasks", new Runnable(){

            public void run() {
                tasks.create("tasks", TaskReportTask.class, (Action)new Action<TaskReportTask>(){

                    public void execute(TaskReportTask task) {
                        String description = project.getChildProjects().isEmpty() ? "Displays the tasks runnable from " + project + "." : "Displays the tasks runnable from " + project + " (some of the displayed tasks may belong to subprojects).";
                        task.setDescription(description);
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
        tasks.addPlaceholderAction(PROPERTIES_TASK, new Runnable(){

            public void run() {
                tasks.create(HelpTasksPlugin.PROPERTIES_TASK, PropertyReportTask.class, (Action)new Action<PropertyReportTask>(){

                    public void execute(PropertyReportTask task) {
                        task.setDescription("Displays the properties of " + project + ".");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
        tasks.addPlaceholderAction(DEPENDENCY_INSIGHT_TASK, new Runnable(){

            public void run() {
                tasks.create(HelpTasksPlugin.DEPENDENCY_INSIGHT_TASK, DependencyInsightReportTask.class, (Action)new Action<DependencyInsightReportTask>(){

                    public void execute(final DependencyInsightReportTask task) {
                        task.setDescription("Displays the insight into a specific dependency in " + project + ".");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                            public void execute(JavaPlugin javaPlugin) {
                                task.setConfiguration(project.getConfigurations().getByName("compile"));
                            }
                        });
                    }
                });
            }
        });
        tasks.addPlaceholderAction(DEPENDENCIES_TASK, new Runnable(){

            public void run() {
                tasks.create(HelpTasksPlugin.DEPENDENCIES_TASK, DependencyReportTask.class, (Action)new Action<DependencyReportTask>(){

                    public void execute(DependencyReportTask task) {
                        task.setDescription("Displays all dependencies declared in " + project + ".");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
        tasks.addPlaceholderAction(COMPONENTS_TASK, new Runnable(){

            public void run() {
                tasks.create(HelpTasksPlugin.COMPONENTS_TASK, ComponentReport.class, (Action)new Action<ComponentReport>(){

                    public void execute(ComponentReport task) {
                        task.setDescription("Displays the components produced by " + project + ". [incubating]");
                        task.setGroup(HelpTasksPlugin.HELP_GROUP);
                        task.setImpliesSubProjects(true);
                    }
                });
            }
        });
    }
}

