/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentReportRenderer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.test.TestSuiteContainer;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;

@Incubating
public class ComponentReport
extends DefaultTask {
    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        BinaryContainer binaries;
        Project project = this.getProject();
        StyledTextOutput textOutput = this.getTextOutputFactory().create(ComponentReport.class);
        ComponentReportRenderer renderer = new ComponentReportRenderer(this.getFileResolver());
        renderer.setOutput(textOutput);
        renderer.startProject(project);
        ArrayList<ComponentSpec> components = new ArrayList<ComponentSpec>();
        ComponentSpecContainer componentSpecs = (ComponentSpecContainer)project.getExtensions().findByType(ComponentSpecContainer.class);
        if (componentSpecs != null) {
            components.addAll((Collection<ComponentSpec>)componentSpecs);
        }
        try {
            TestSuiteContainer testSuites = (TestSuiteContainer)this.getModelRegistry().get(ModelPath.path((String)"testSuites"), ModelType.of(TestSuiteContainer.class));
            components.addAll((Collection<ComponentSpec>)testSuites);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        renderer.renderComponents(components);
        ProjectSourceSet sourceSets = (ProjectSourceSet)project.getExtensions().findByType(ProjectSourceSet.class);
        if (sourceSets != null) {
            renderer.renderSourceSets((Collection<FunctionalSourceSet>)sourceSets);
        }
        if ((binaries = (BinaryContainer)project.getExtensions().findByType(BinaryContainer.class)) != null) {
            renderer.renderBinaries((Collection<BinarySpec>)binaries);
        }
        renderer.completeProject(project);
        renderer.complete();
    }
}

