/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.BinaryRenderer;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRenderer
extends ReportRenderer<ComponentSpec, TextReportBuilder> {
    private final SourceSetRenderer sourceSetRenderer;
    private final BinaryRenderer renderer;

    public ComponentRenderer(FileResolver fileResolver) {
        this.sourceSetRenderer = new SourceSetRenderer(fileResolver);
        this.renderer = new BinaryRenderer(fileResolver);
    }

    public void render(ComponentSpec component, TextReportBuilder builder) {
        builder.subheading(StringUtils.capitalize((String)component.getDisplayName()));
        builder.getOutput().println();
        builder.collection("Source sets", component.getSource(), this.sourceSetRenderer, "source sets");
        builder.getOutput().println();
        builder.collection("Binaries", CollectionUtils.sort((Iterable)component.getBinaries(), (Comparator)new Comparator<BinarySpec>(){

            @Override
            public int compare(BinarySpec binary1, BinarySpec binary2) {
                return binary1.getName().compareTo(binary2.getName());
            }
        }), this.renderer, "binaries");
    }
}

