/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.logging.StyledTextOutputFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportTask
extends ConventionTask {
    private File outputFile;
    private Set<Project> projects;

    protected AbstractReportTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return false;
            }
        });
        this.projects = new HashSet<Project>();
        this.projects.add(this.getProject());
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        try {
            ReportRenderer renderer = this.getRenderer();
            File outputFile = this.getOutputFile();
            if (outputFile != null) {
                renderer.setOutputFile(outputFile);
            } else {
                renderer.setOutput(this.getTextOutputFactory().create(((Object)((Object)this)).getClass()));
            }
            TreeSet<Project> projects = new TreeSet<Project>(this.getProjects());
            for (Project project : projects) {
                renderer.startProject(project);
                this.generate(project);
                renderer.completeProject(project);
            }
            renderer.complete();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    protected abstract ReportRenderer getRenderer();

    protected abstract void generate(Project var1) throws IOException;

    @OutputFile
    @Optional
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }
}

