/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.ANTLR;
import org.apache.tools.ant.types.Path;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.antlr.internal.GenerationPlan;
import org.gradle.api.plugins.antlr.internal.GenerationPlanBuilder;
import org.gradle.api.plugins.antlr.internal.MetadataExtracter;
import org.gradle.api.plugins.antlr.internal.XRef;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrTask
extends SourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrTask.class);
    private boolean trace;
    private boolean traceLexer;
    private boolean traceParser;
    private boolean traceTreeWalker;
    private FileCollection antlrClasspath;
    private File outputDirectory;

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isTraceLexer() {
        return this.traceLexer;
    }

    public void setTraceLexer(boolean traceLexer) {
        this.traceLexer = traceLexer;
    }

    public boolean isTraceParser() {
        return this.traceParser;
    }

    public void setTraceParser(boolean traceParser) {
        this.traceParser = traceParser;
    }

    public boolean isTraceTreeWalker() {
        return this.traceTreeWalker;
    }

    public void setTraceTreeWalker(boolean traceTreeWalker) {
        this.traceTreeWalker = traceTreeWalker;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @InputFiles
    public FileCollection getAntlrClasspath() {
        return this.antlrClasspath;
    }

    public void setAntlrClasspath(FileCollection antlrClasspath) {
        this.antlrClasspath = antlrClasspath;
    }

    @TaskAction
    public void generate() {
        XRef xref = new MetadataExtracter().extractMetadata(this.getSource());
        List<GenerationPlan> generationPlans = new GenerationPlanBuilder(this.outputDirectory).buildGenerationPlans(xref);
        for (GenerationPlan generationPlan : generationPlans) {
            if (!generationPlan.isOutOfDate()) {
                LOGGER.info("grammar [" + generationPlan.getId() + "] was up-to-date; skipping");
                continue;
            }
            LOGGER.info("performing grammar generation [" + generationPlan.getId() + "]");
            GFileUtils.mkdirs((File)generationPlan.getGenerationDirectory());
            ANTLR antlr = new ANTLR();
            antlr.setProject(this.getAnt().getAntProject());
            Path antlrTaskClasspath = antlr.createClasspath();
            for (File dep : this.getAntlrClasspath()) {
                antlrTaskClasspath.createPathElement().setLocation(dep);
            }
            antlr.setTrace(this.trace);
            antlr.setTraceLexer(this.traceLexer);
            antlr.setTraceParser(this.traceParser);
            antlr.setTraceTreeWalker(this.traceTreeWalker);
            antlr.setOutputdirectory(generationPlan.getGenerationDirectory());
            antlr.setTarget(generationPlan.getSource());
            antlr.execute();
        }
    }
}

