/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsExecuter;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsWorkerClientProtocol;
import org.gradle.process.internal.WorkerProcessContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorkerServer
implements Action<WorkerProcessContext>,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(FindBugsWorkerServer.class);
    private FindBugsSpec spec;

    public FindBugsWorkerServer(FindBugsSpec spec) {
        this.spec = spec;
    }

    public void execute(WorkerProcessContext context) {
        FindBugsResult result = this.execute();
        FindBugsWorkerClientProtocol clientProtocol = (FindBugsWorkerClientProtocol)context.getServerConnection().addOutgoing(FindBugsWorkerClientProtocol.class);
        context.getServerConnection().connect();
        clientProtocol.executed(result);
    }

    public FindBugsResult execute() {
        LOGGER.debug("Executing FindBugs worker.");
        try {
            FindBugsExecuter findBugsExecuter = new FindBugsExecuter();
            return findBugsExecuter.runFindbugs(this.spec);
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred while running FindBugs.", (Throwable)e);
            return new FindBugsResult(0, 0, 1, e);
        }
    }
}

