/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.IvyArtifactName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedArtifact
implements ResolvedArtifact {
    private final ResolvedModuleVersion owner;
    private final IvyArtifactName artifact;
    private long id;
    private Factory<File> artifactSource;
    private File file;

    public DefaultResolvedArtifact(ResolvedModuleVersion owner, IvyArtifactName artifact, Factory<File> artifactSource, long id) {
        this.owner = owner;
        this.artifact = artifact;
        this.id = id;
        this.artifactSource = artifactSource;
    }

    public long getId() {
        return this.id;
    }

    public ResolvedModuleVersion getModuleVersion() {
        return this.owner;
    }

    public String toString() {
        return String.format("[ResolvedArtifact dependency:%s name:%s classifier:%s extension:%s type:%s]", this.owner, this.getName(), this.getClassifier(), this.getExtension(), this.getType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        if (!other.owner.getId().equals(this.owner.getId())) {
            return false;
        }
        return other.artifact.equals(this.artifact);
    }

    public int hashCode() {
        return this.owner.getId().hashCode() ^ this.getName().hashCode() ^ this.getType().hashCode() ^ this.getExtension().hashCode() ^ this.artifact.hashCode();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public File getFile() {
        if (this.file == null) {
            this.file = (File)this.artifactSource.create();
            this.artifactSource = null;
        }
        return this.file;
    }
}

