/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetaData;
import org.gradle.internal.component.local.model.MutableLocalComponentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyBackedArtifactPublisher
implements ArtifactPublisher {
    private final LocalComponentFactory publishLocalComponentFactory;
    private final IvyContextManager ivyContextManager;
    private final IvyDependencyPublisher dependencyPublisher;
    private final IvyModuleDescriptorWriter ivyModuleDescriptorWriter;

    public IvyBackedArtifactPublisher(LocalComponentFactory publishLocalComponentFactory, IvyContextManager ivyContextManager, IvyDependencyPublisher dependencyPublisher, IvyModuleDescriptorWriter ivyModuleDescriptorWriter) {
        this.publishLocalComponentFactory = publishLocalComponentFactory;
        this.ivyContextManager = ivyContextManager;
        this.dependencyPublisher = dependencyPublisher;
        this.ivyModuleDescriptorWriter = ivyModuleDescriptorWriter;
    }

    @Override
    public void publish(final Iterable<? extends PublicationAwareRepository> repositories, final ModuleInternal module, final Configuration configuration, final File descriptor) throws PublishException {
        this.ivyContextManager.withIvy((Action<? super Ivy>)new Action<Ivy>(){

            public void execute(Ivy ivy) {
                Set allConfigurations = configuration.getAll();
                Set configurationsToPublish = configuration.getHierarchy();
                MutableLocalComponentMetaData componentMetaData = IvyBackedArtifactPublisher.this.publishLocalComponentFactory.convert(allConfigurations, module);
                if (descriptor != null) {
                    ModuleDescriptor moduleDescriptor = componentMetaData.getModuleDescriptor();
                    IvyBackedArtifactPublisher.this.ivyModuleDescriptorWriter.write(moduleDescriptor, descriptor);
                }
                componentMetaData = IvyBackedArtifactPublisher.this.publishLocalComponentFactory.convert(configurationsToPublish, module);
                BuildableIvyModulePublishMetaData publishMetaData = componentMetaData.toPublishMetaData();
                if (descriptor != null) {
                    Artifact artifact = MDArtifact.newIvyArtifact((ModuleDescriptor)componentMetaData.getModuleDescriptor());
                    publishMetaData.addArtifact(artifact, descriptor);
                }
                ArrayList<ModuleVersionPublisher> publishResolvers = new ArrayList<ModuleVersionPublisher>();
                for (PublicationAwareRepository repository : repositories) {
                    ModuleVersionPublisher publisher = repository.createPublisher();
                    publishResolvers.add(publisher);
                }
                IvyBackedArtifactPublisher.this.dependencyPublisher.publish(publishResolvers, publishMetaData);
            }
        });
    }
}

