/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.DefaultDependencyResolveDetails;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionForcingDependencyToModuleResolver
implements DependencyToComponentIdResolver {
    private final DependencyToComponentIdResolver resolver;
    private final Action<DependencyResolveDetailsInternal> rule;

    public VersionForcingDependencyToModuleResolver(DependencyToComponentIdResolver resolver, Action<DependencyResolveDetailsInternal> rule) {
        this.resolver = resolver;
        this.rule = rule;
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        ModuleVersionSelector module = dependency.getRequested();
        DefaultDependencyResolveDetails details = new DefaultDependencyResolveDetails(module);
        try {
            this.rule.execute((Object)details);
        }
        catch (Throwable e) {
            result.failed(new ModuleVersionResolveException(module, e));
            return;
        }
        if (details.isUpdated()) {
            DependencyMetaData substitutedDependency = dependency.withRequestedVersion(details.getTarget());
            this.resolver.resolve(substitutedDependency, result);
            result.setSelectionReason(details.getSelectionReason());
            return;
        }
        this.resolver.resolve(dependency, result);
    }
}

