/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.io.File;
import java.math.BigInteger;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetaDataCache;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentUsage;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentVersionSelectionResolveResult;
import org.gradle.internal.resolve.result.ModuleVersionListing;
import org.gradle.internal.resource.cached.CachedArtifact;
import org.gradle.internal.resource.cached.CachedArtifactIndex;
import org.gradle.internal.resource.cached.ivy.ArtifactAtRepositoryKey;
import org.gradle.util.BuildCommencedTimeProvider;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingModuleComponentRepository
implements ModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModuleComponentRepository.class);
    private final ModuleVersionsCache moduleVersionsCache;
    private final ModuleMetaDataCache moduleMetaDataCache;
    private final ModuleArtifactsCache moduleArtifactsCache;
    private final CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex;
    private final CachePolicy cachePolicy;
    private final ModuleComponentRepository delegate;
    private final BuildCommencedTimeProvider timeProvider;
    private final ComponentMetadataProcessor metadataProcessor;
    private LocateInCacheRepositoryAccess locateInCacheRepositoryAccess = new LocateInCacheRepositoryAccess();
    private ResolveAndCacheRepositoryAccess resolveAndCacheRepositoryAccess = new ResolveAndCacheRepositoryAccess();

    public CachingModuleComponentRepository(ModuleComponentRepository delegate, ModuleVersionsCache moduleVersionsCache, ModuleMetaDataCache moduleMetaDataCache, ModuleArtifactsCache moduleArtifactsCache, CachedArtifactIndex artifactAtRepositoryCachedResolutionIndex, CachePolicy cachePolicy, BuildCommencedTimeProvider timeProvider, ComponentMetadataProcessor metadataProcessor) {
        this.delegate = delegate;
        this.moduleMetaDataCache = moduleMetaDataCache;
        this.moduleVersionsCache = moduleVersionsCache;
        this.moduleArtifactsCache = moduleArtifactsCache;
        this.artifactAtRepositoryCachedResolutionIndex = artifactAtRepositoryCachedResolutionIndex;
        this.timeProvider = timeProvider;
        this.cachePolicy = cachePolicy;
        this.metadataProcessor = metadataProcessor;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.locateInCacheRepositoryAccess;
    }

    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.resolveAndCacheRepositoryAccess;
    }

    private DefaultModuleIdentifier getCacheKey(ModuleVersionSelector requested) {
        return new DefaultModuleIdentifier(requested.getGroup(), requested.getName());
    }

    private String cacheKey(ArtifactType artifactType) {
        return "artifacts:" + artifactType.name();
    }

    private String cacheKey(ComponentUsage context) {
        return "configuration:" + context.getConfigurationName();
    }

    private ArtifactAtRepositoryKey artifactCacheKey(ComponentArtifactMetaData artifact) {
        ModuleComponentArtifactMetaData moduleComponentArtifactMetaData = (ModuleComponentArtifactMetaData)artifact;
        return new ArtifactAtRepositoryKey(this.delegate.getId(), moduleComponentArtifactMetaData.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArtifactMetaDataToId
    implements Transformer<ModuleComponentArtifactIdentifier, ComponentArtifactMetaData> {
        ArtifactMetaDataToId() {
        }

        public ModuleComponentArtifactIdentifier transform(ComponentArtifactMetaData original) {
            return ((ModuleComponentArtifactMetaData)original).getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArtifactIdToMetaData
    implements Transformer<ModuleComponentArtifactMetaData, ModuleComponentArtifactIdentifier> {
        ArtifactIdToMetaData() {
        }

        public ModuleComponentArtifactMetaData transform(ModuleComponentArtifactIdentifier original) {
            return new DefaultModuleComponentArtifactMetaData(original);
        }
    }

    static class CachingModuleSource
    implements ModuleSource {
        private final BigInteger descriptorHash;
        private final boolean changingModule;
        private final ModuleSource delegate;

        public CachingModuleSource(BigInteger descriptorHash, boolean changingModule, ModuleSource delegate) {
            this.delegate = delegate;
            this.descriptorHash = descriptorHash;
            this.changingModule = changingModule;
        }

        public BigInteger getDescriptorHash() {
            return this.descriptorHash;
        }

        public boolean isChangingModule() {
            return this.changingModule;
        }

        public ModuleSource getDelegate() {
            return this.delegate;
        }
    }

    private class ResolveAndCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private ResolveAndCacheRepositoryAccess() {
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleComponentVersionSelectionResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().listModuleVersions(dependency, result);
            switch (result.getState()) {
                case Listed: {
                    DefaultModuleIdentifier moduleId = CachingModuleComponentRepository.this.getCacheKey(dependency.getRequested());
                    ModuleVersionListing versionList = result.getVersions();
                    CachingModuleComponentRepository.this.moduleVersionsCache.cacheModuleVersionList(CachingModuleComponentRepository.this.delegate, moduleId, versionList);
                    break;
                }
                case Failed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state on listModuleVersions: " + (Object)((Object)result.getState()));
                }
            }
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
            DependencyMetaData forced = dependency.withChanging();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveComponentMetaData(forced, moduleComponentIdentifier, result);
            switch (result.getState()) {
                case Missing: {
                    CachingModuleComponentRepository.this.moduleMetaDataCache.cacheMissing(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
                    break;
                }
                case Resolved: {
                    MutableModuleComponentResolveMetaData metaData = result.getMetaData();
                    ModuleSource moduleSource = metaData.getSource();
                    ModuleMetaDataCache.CachedMetaData cachedMetaData = CachingModuleComponentRepository.this.moduleMetaDataCache.cacheMetaData(CachingModuleComponentRepository.this.delegate, metaData);
                    CachingModuleComponentRepository.this.metadataProcessor.processMetadata(metaData);
                    moduleSource = new CachingModuleSource(cachedMetaData.getDescriptorHash(), dependency.isChanging() || metaData.isChanging(), moduleSource);
                    metaData.setSource(moduleSource);
                    result.resolved(metaData);
                    break;
                }
                case Failed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected resolve state: " + (Object)((Object)result.getState()));
                }
            }
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleSource moduleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component.withSource(moduleSource.getDelegate()), artifactType, result);
            this.maybeCache(component, result, moduleSource, CachingModuleComponentRepository.this.cacheKey(artifactType));
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            CachingModuleSource moduleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveModuleArtifacts(component.withSource(moduleSource.getDelegate()), componentUsage, result);
            this.maybeCache(component, result, moduleSource, CachingModuleComponentRepository.this.cacheKey(componentUsage));
        }

        private void maybeCache(ComponentResolveMetaData component, BuildableArtifactSetResolveResult result, CachingModuleSource moduleSource, String contextId) {
            if (result.getFailure() == null) {
                Set artifactIdentifierSet = CollectionUtils.collect(result.getArtifacts(), (Transformer)new ArtifactMetaDataToId());
                CachingModuleComponentRepository.this.moduleArtifactsCache.cacheArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), contextId, moduleSource.getDescriptorHash(), artifactIdentifierSet);
            }
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachingModuleSource cachingModuleSource = (CachingModuleSource)moduleSource;
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifact(artifact, cachingModuleSource.getDelegate(), result);
            LOGGER.debug("Downloaded artifact '{}' from resolver: {}", (Object)artifact, (Object)CachingModuleComponentRepository.this.delegate.getName());
            ArtifactResolveException failure = result.getFailure();
            if (failure == null) {
                CachingModuleComponentRepository.this.artifactAtRepositoryCachedResolutionIndex.store(CachingModuleComponentRepository.this.artifactCacheKey(artifact), result.getFile(), cachingModuleSource.getDescriptorHash());
            } else if (failure instanceof ArtifactNotFoundException) {
                CachingModuleComponentRepository.this.artifactAtRepositoryCachedResolutionIndex.storeMissing(CachingModuleComponentRepository.this.artifactCacheKey(artifact), result.getAttempted(), cachingModuleSource.getDescriptorHash());
            }
        }
    }

    private class LocateInCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private LocateInCacheRepositoryAccess() {
        }

        public void listModuleVersions(DependencyMetaData dependency, BuildableModuleComponentVersionSelectionResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().listModuleVersions(dependency, result);
            if (result.hasResult()) {
                return;
            }
            this.listModuleVersionsFromCache(dependency, result);
        }

        private void listModuleVersionsFromCache(DependencyMetaData dependency, BuildableModuleComponentVersionSelectionResolveResult result) {
            ModuleVersionSelector requested = dependency.getRequested();
            final DefaultModuleIdentifier moduleId = CachingModuleComponentRepository.this.getCacheKey(requested);
            ModuleVersionsCache.CachedModuleVersionList cachedModuleVersionList = CachingModuleComponentRepository.this.moduleVersionsCache.getCachedModuleResolution(CachingModuleComponentRepository.this.delegate, moduleId);
            if (cachedModuleVersionList != null) {
                ModuleVersionListing versionList = cachedModuleVersionList.getModuleVersions();
                Set versions = CollectionUtils.collect(versionList.getVersions(), (Transformer)new Transformer<ModuleVersionIdentifier, Versioned>(){

                    public ModuleVersionIdentifier transform(Versioned original) {
                        return new DefaultModuleVersionIdentifier(moduleId, original.getVersion());
                    }
                });
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshVersionList((ModuleIdentifier)moduleId, versions, cachedModuleVersionList.getAgeMillis())) {
                    LOGGER.debug("Version listing in dynamic revision cache is expired: will perform fresh resolve of '{}' in '{}'", (Object)requested, (Object)CachingModuleComponentRepository.this.delegate.getName());
                } else {
                    result.listed(versionList);
                    result.setAuthoritative(cachedModuleVersionList.getAgeMillis() == 0L);
                }
            }
        }

        public void resolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveComponentMetaData(dependency, moduleComponentIdentifier, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveComponentMetaDataFromCache(dependency, moduleComponentIdentifier, result);
        }

        private void resolveComponentMetaDataFromCache(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
            ModuleMetaDataCache.CachedMetaData cachedMetaData = CachingModuleComponentRepository.this.moduleMetaDataCache.getCachedModuleDescriptor(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
            if (cachedMetaData == null) {
                return;
            }
            if (cachedMetaData.isMissing()) {
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshMissingModule(moduleComponentIdentifier, cachedMetaData.getAgeMillis())) {
                    LOGGER.debug("Cached meta-data for missing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Detected non-existence of module '{}' in resolver cache '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                result.missing();
                result.setAuthoritative(cachedMetaData.getAgeMillis() == 0L);
                return;
            }
            MutableModuleComponentResolveMetaData metaData = cachedMetaData.getMetaData();
            CachingModuleComponentRepository.this.metadataProcessor.processMetadata(metaData);
            if (dependency.isChanging() || metaData.isChanging()) {
                if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshChangingModule(moduleComponentIdentifier, cachedMetaData.getModuleVersion(), cachedMetaData.getAgeMillis())) {
                    LOGGER.debug("Cached meta-data for changing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Found cached version of changing module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
            } else if (CachingModuleComponentRepository.this.cachePolicy.mustRefreshModule(moduleComponentIdentifier, cachedMetaData.getModuleVersion(), cachedMetaData.getAgeMillis())) {
                LOGGER.debug("Cached meta-data for module must be refreshed: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                return;
            }
            LOGGER.debug("Using cached module metadata for module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
            metaData.setSource(new CachingModuleSource(cachedMetaData.getDescriptorHash(), metaData.isChanging(), metaData.getSource()));
            result.resolved(metaData);
            result.setAuthoritative(cachedMetaData.getAgeMillis() == 0L);
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component.withSource(cachedModuleSource.getDelegate()), artifactType, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveModuleArtifactsFromCache(CachingModuleComponentRepository.this.cacheKey(artifactType), component, result, cachedModuleSource);
        }

        public void resolveModuleArtifacts(ComponentResolveMetaData component, ComponentUsage componentUsage, BuildableArtifactSetResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)component.getSource();
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveModuleArtifacts(component.withSource(cachedModuleSource.getDelegate()), componentUsage, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveModuleArtifactsFromCache(CachingModuleComponentRepository.this.cacheKey(componentUsage), component, result, cachedModuleSource);
        }

        private void resolveModuleArtifactsFromCache(String contextId, ComponentResolveMetaData component, BuildableArtifactSetResolveResult result, CachingModuleSource cachedModuleSource) {
            ModuleArtifactsCache.CachedArtifacts cachedModuleArtifacts = CachingModuleComponentRepository.this.moduleArtifactsCache.getCachedArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), contextId);
            BigInteger moduleDescriptorHash = cachedModuleSource.getDescriptorHash();
            if (cachedModuleArtifacts != null) {
                if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshModuleArtifacts(component.getId(), null, cachedModuleArtifacts.getAgeMillis(), cachedModuleSource.isChangingModule(), moduleDescriptorHash.equals(cachedModuleArtifacts.getDescriptorHash()))) {
                    Set artifactMetaDataSet = CollectionUtils.collect(cachedModuleArtifacts.getArtifacts(), (Transformer)new ArtifactIdToMetaData());
                    result.resolved(artifactMetaDataSet);
                    return;
                }
                LOGGER.debug("Artifact listing has expired: will perform fresh resolve of '{}' for '{}' in '{}'", new Object[]{contextId, component.getId(), CachingModuleComponentRepository.this.delegate.getName()});
            }
        }

        public void resolveArtifact(ComponentArtifactMetaData artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachingModuleSource cachedModuleSource = (CachingModuleSource)moduleSource;
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifact(artifact, cachedModuleSource.getDelegate(), result);
            if (result.hasResult()) {
                return;
            }
            this.resolveArtifactFromCache(artifact, cachedModuleSource, result);
        }

        private void resolveArtifactFromCache(ComponentArtifactMetaData artifact, CachingModuleSource moduleSource, BuildableArtifactResolveResult result) {
            CachedArtifact cached = CachingModuleComponentRepository.this.artifactAtRepositoryCachedResolutionIndex.lookup(CachingModuleComponentRepository.this.artifactCacheKey(artifact));
            BigInteger descriptorHash = moduleSource.getDescriptorHash();
            if (cached != null) {
                long age = CachingModuleComponentRepository.this.timeProvider.getCurrentTime() - cached.getCachedAt();
                boolean isChangingModule = moduleSource.isChangingModule();
                ArtifactIdentifier artifactIdentifier = ((ModuleComponentArtifactMetaData)artifact).toArtifactIdentifier();
                if (cached.isMissing()) {
                    if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshArtifact(artifactIdentifier, null, age, isChangingModule, descriptorHash.equals(cached.getDescriptorHash()))) {
                        LOGGER.debug("Detected non-existence of artifact '{}' in resolver cache", (Object)artifact);
                        for (String location : cached.attemptedLocations()) {
                            result.attempted(location);
                        }
                        result.notFound(artifact.getId());
                    }
                } else {
                    File cachedArtifactFile = cached.getCachedFile();
                    if (!CachingModuleComponentRepository.this.cachePolicy.mustRefreshArtifact(artifactIdentifier, cachedArtifactFile, age, isChangingModule, descriptorHash.equals(cached.getDescriptorHash()))) {
                        LOGGER.debug("Found artifact '{}' in resolver cache: {}", (Object)artifact, (Object)cachedArtifactFile);
                        result.resolved(cachedArtifactFile);
                    }
                }
            }
        }
    }
}

