/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;

class ComponentMetaDataResolveState {
    private final DefaultBuildableModuleComponentMetaDataResolveResult resolveResult = new DefaultBuildableModuleComponentMetaDataResolveResult();
    private final ComponentChooser componentChooser;
    private final DependencyMetaData dependency;
    final ModuleComponentIdentifier componentIdentifier;
    final ModuleComponentRepository repository;
    private boolean searchedLocally;
    private boolean searchedRemotely;

    public ComponentMetaDataResolveState(DependencyMetaData dependency, ModuleComponentIdentifier componentIdentifier, ModuleComponentRepository repository, ComponentChooser componentChooser) {
        this.dependency = dependency;
        this.componentIdentifier = componentIdentifier;
        this.repository = repository;
        this.componentChooser = componentChooser;
    }

    BuildableModuleComponentMetaDataResolveResult resolve() {
        if (!this.searchedLocally) {
            this.searchedLocally = true;
            this.process(this.dependency, this.componentIdentifier, this.repository.getLocalAccess(), this.resolveResult);
            if (this.resolveResult.getState() != BuildableModuleComponentMetaDataResolveResult.State.Unknown) {
                if (this.resolveResult.isAuthoritative()) {
                    this.searchedRemotely = true;
                }
                return this.resolveResult;
            }
        }
        if (!this.searchedRemotely) {
            this.searchedRemotely = true;
            this.process(this.dependency, this.componentIdentifier, this.repository.getRemoteAccess(), this.resolveResult);
            return this.resolveResult;
        }
        throw new IllegalStateException();
    }

    protected void process(DependencyMetaData dependency, ModuleComponentIdentifier componentIdentifier, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleComponentMetaDataResolveResult resolveResult) {
        moduleAccess.resolveComponentMetaData(dependency, componentIdentifier, resolveResult);
        if (resolveResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
            throw resolveResult.getFailure();
        }
        if (resolveResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved && this.componentChooser.isRejectedByRules(componentIdentifier, (Factory<? extends MutableModuleComponentResolveMetaData>)Factories.constant((Object)resolveResult.getMetaData()))) {
            resolveResult.missing();
        }
    }

    protected void applyTo(ResourceAwareResolveResult result) {
        this.resolveResult.applyTo(result);
    }

    public boolean canMakeFurtherAttempts() {
        return !this.searchedRemotely;
    }
}

