/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectionInternal;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.IvyModuleResolveMetaData;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.rules.SpecRuleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSelectionRulesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentSelectionRulesProcessor.class);
    private static final String USER_CODE_ERROR = "Could not apply component selection rule with all().";

    public void apply(ComponentSelectionInternal selection, Collection<SpecRuleAction<? super ComponentSelection>> specRuleActions, Factory<? extends MutableModuleComponentResolveMetaData> metaDataSupplier) {
        MetadataProvider metadataProvider = new MetadataProvider(metaDataSupplier);
        ArrayList noInputRules = Lists.newArrayList();
        ArrayList inputRules = Lists.newArrayList();
        for (SpecRuleAction<? super ComponentSelection> specRuleAction : specRuleActions) {
            if (specRuleAction.getAction().getInputTypes().isEmpty()) {
                noInputRules.add(specRuleAction);
                continue;
            }
            inputRules.add(specRuleAction);
        }
        if (this.processRules(noInputRules, selection, metadataProvider)) {
            this.processRules(inputRules, selection, metadataProvider);
        }
    }

    private boolean processRules(List<SpecRuleAction<? super ComponentSelection>> specRuleActions, ComponentSelectionInternal selection, MetadataProvider metadataProvider) {
        for (SpecRuleAction<? super ComponentSelection> rule : specRuleActions) {
            this.processRule(selection, metadataProvider, rule);
            if (!selection.isRejected()) continue;
            LOGGER.info(String.format("Selection of '%s' rejected by component selection rule: %s", selection.getCandidate(), selection.getRejectionReason()));
            return false;
        }
        return true;
    }

    private void processRule(ComponentSelection selection, MetadataProvider metadataProvider, SpecRuleAction<? super ComponentSelection> specRuleAction) {
        if (!specRuleAction.getSpec().isSatisfiedBy((Object)selection)) {
            return;
        }
        ArrayList inputs = Lists.newArrayList();
        for (Class<?> inputType : specRuleAction.getAction().getInputTypes()) {
            if (inputType == ModuleComponentResolveMetaData.class) {
                inputs.add(metadataProvider.getMetaData());
                continue;
            }
            if (inputType == ComponentMetadata.class) {
                inputs.add(metadataProvider.getComponentMetadata());
                continue;
            }
            if (inputType == IvyModuleDescriptor.class) {
                IvyModuleDescriptor ivyModuleDescriptor = metadataProvider.getIvyModuleDescriptor();
                if (ivyModuleDescriptor == null) {
                    return;
                }
                inputs.add(ivyModuleDescriptor);
                continue;
            }
            throw new IllegalStateException();
        }
        try {
            specRuleAction.getAction().execute((ComponentSelection)selection, inputs);
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(USER_CODE_ERROR, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetadataProvider {
        private final Factory<? extends MutableModuleComponentResolveMetaData> metaDataSupplier;
        private MutableModuleComponentResolveMetaData cachedMetaData;

        private MetadataProvider(Factory<? extends MutableModuleComponentResolveMetaData> metaDataSupplier) {
            this.metaDataSupplier = metaDataSupplier;
        }

        public ComponentMetadata getComponentMetadata() {
            return new ComponentMetadataDetailsAdapter(this.getMetaData());
        }

        public IvyModuleDescriptor getIvyModuleDescriptor() {
            MutableModuleComponentResolveMetaData metaData = this.getMetaData();
            if (metaData instanceof IvyModuleResolveMetaData) {
                IvyModuleResolveMetaData ivyMetadata = (IvyModuleResolveMetaData)((Object)metaData);
                return new DefaultIvyModuleDescriptor(ivyMetadata.getExtraInfo(), ivyMetadata.getBranch(), ivyMetadata.getStatus());
            }
            return null;
        }

        public MutableModuleComponentResolveMetaData getMetaData() {
            if (this.cachedMetaData == null) {
                this.cachedMetaData = (MutableModuleComponentResolveMetaData)this.metaDataSupplier.create();
            }
            return this.cachedMetaData;
        }
    }
}

