/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentVersionSelectionResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicVersionResolver
implements DependencyToComponentIdResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVersionResolver.class);
    private final List<ModuleComponentRepository> repositories = new ArrayList<ModuleComponentRepository>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final ComponentChooser componentChooser;
    private final Transformer<ModuleComponentResolveMetaData, RepositoryChainModuleResolution> metaDataFactory;

    public DynamicVersionResolver(ComponentChooser componentChooser, Transformer<ModuleComponentResolveMetaData, RepositoryChainModuleResolution> metaDataFactory) {
        this.componentChooser = componentChooser;
        this.metaDataFactory = metaDataFactory;
    }

    public void add(ModuleComponentRepository repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        ModuleVersionSelector requested = dependency.getRequested();
        LOGGER.debug("Attempting to resolve {} using repositories {}", (Object)requested, this.repositoryNames);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<RepositoryResolveState> resolveStates = new ArrayList<RepositoryResolveState>();
        for (ModuleComponentRepository repository : this.repositories) {
            resolveStates.add(new RepositoryResolveState(repository));
        }
        RepositoryChainModuleResolution latestResolved = this.findLatestModule(dependency, resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.module.getId(), (Object)latestResolved.repository);
            for (Throwable error : errors) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            result.resolved((ComponentResolveMetaData)this.metaDataFactory.transform((Object)latestResolved));
            return;
        }
        if (!errors.isEmpty()) {
            result.failed(new ModuleVersionResolveException(requested, errors));
        } else {
            for (RepositoryResolveState resolveState : resolveStates) {
                resolveState.applyTo(result);
            }
            result.notFound(requested);
        }
    }

    private RepositoryChainModuleResolution findLatestModule(DependencyMetaData dependency, List<RepositoryResolveState> resolveStates, Collection<Throwable> failures) {
        LinkedList<RepositoryResolveState> queue = new LinkedList<RepositoryResolveState>();
        queue.addAll(resolveStates);
        LinkedList<RepositoryResolveState> missing = new LinkedList<RepositoryResolveState>();
        RepositoryChainModuleResolution best = this.findLatestModule(dependency, queue, failures, missing);
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findLatestModule(dependency, queue, failures, missing);
    }

    private RepositoryChainModuleResolution findLatestModule(DependencyMetaData dependency, LinkedList<RepositoryResolveState> queue, Collection<Throwable> failures, Collection<RepositoryResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block7: while (!queue.isEmpty()) {
            RepositoryResolveState request = queue.removeFirst();
            try {
                request.resolve(dependency);
            }
            catch (Throwable t) {
                failures.add(t);
                continue;
            }
            switch (request.resolveResult.getState()) {
                case Missing: {
                    if (request.resolveResult.isAuthoritative() || !request.canMakeFurtherAttempts()) continue block7;
                    missing.add(request);
                    continue block7;
                }
                case Unknown: {
                    if (!request.canMakeFurtherAttempts()) continue block7;
                    queue.addFirst(request);
                    continue block7;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, request.resolveResult.getMetaData());
                    best = this.chooseBest(best, moduleResolution);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)request.resolveResult.getState()));
        }
        return best;
    }

    private RepositoryChainModuleResolution chooseBest(RepositoryChainModuleResolution one, RepositoryChainModuleResolution two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        return this.componentChooser.choose(one.module, two.module) == one.module ? one : two;
    }

    public class RepositoryResolveState {
        private final DefaultBuildableModuleComponentMetaDataResolveResult resolveResult = new DefaultBuildableModuleComponentMetaDataResolveResult();
        final DefaultBuildableModuleComponentVersionSelectionResolveResult selectionResult = new DefaultBuildableModuleComponentVersionSelectionResolveResult();
        final ModuleComponentRepository repository;
        private boolean searchedLocally;
        boolean searchedRemotely;

        public RepositoryResolveState(ModuleComponentRepository repository) {
            this.repository = repository;
        }

        void resolve(DependencyMetaData dependency) {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(dependency, this.repository.getLocalAccess(), this.resolveResult);
            } else {
                this.searchedRemotely = true;
                this.process(dependency, this.repository.getRemoteAccess(), this.resolveResult);
            }
            if (this.resolveResult.getState() == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
                throw this.resolveResult.getFailure();
            }
        }

        protected void process(DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleComponentMetaDataResolveResult resolveResult) {
            moduleAccess.listModuleVersions(dependency, this.selectionResult);
            switch (this.selectionResult.getState()) {
                case Failed: {
                    resolveResult.failed(this.selectionResult.getFailure());
                    break;
                }
                case Listed: {
                    if (this.resolveDependency(dependency, moduleAccess, resolveResult)) break;
                    resolveResult.missing();
                    resolveResult.setAuthoritative(this.selectionResult.isAuthoritative());
                }
            }
        }

        private boolean resolveDependency(DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess, BuildableModuleComponentMetaDataResolveResult resolveResult) {
            ModuleComponentIdentifier componentIdentifier = DynamicVersionResolver.this.componentChooser.choose(this.selectionResult.getVersions(), dependency, moduleAccess);
            if (componentIdentifier == null) {
                return false;
            }
            dependency = dependency.withRequestedVersion(componentIdentifier.getVersion());
            moduleAccess.resolveComponentMetaData(dependency, componentIdentifier, resolveResult);
            return true;
        }

        protected void applyTo(ResourceAwareResolveResult result) {
            this.resolveResult.applyTo(result);
            this.selectionResult.applyTo(result);
        }

        public boolean canMakeFurtherAttempts() {
            return !this.searchedRemotely;
        }
    }
}

