/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.DefaultComponentSelection;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentSelectionRulesProcessor;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ModuleVersionListing;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.SpecRuleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewestVersionComponentChooser
implements ComponentChooser {
    private final ComponentSelectionRulesProcessor rulesProcessor = new ComponentSelectionRulesProcessor();
    private final VersionMatcher versionMatcher;
    private final LatestStrategy latestStrategy;
    private final ComponentSelectionRulesInternal componentSelectionRules;

    NewestVersionComponentChooser(LatestStrategy latestStrategy, VersionMatcher versionMatcher, ComponentSelectionRulesInternal componentSelectionRules) {
        this.latestStrategy = latestStrategy;
        this.versionMatcher = versionMatcher;
        this.componentSelectionRules = componentSelectionRules;
    }

    @Override
    public boolean canSelectMultipleComponents(ModuleVersionSelector selector) {
        return this.versionMatcher.isDynamic(selector.getVersion());
    }

    @Override
    public ComponentResolveMetaData choose(ComponentResolveMetaData one, ComponentResolveMetaData two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        int comparison = this.latestStrategy.compare(new VersionInfo(one.getId().getVersion()), new VersionInfo(two.getId().getVersion()));
        if (comparison == 0) {
            if (this.isGeneratedModuleDescriptor(one) && !this.isGeneratedModuleDescriptor(two)) {
                return two;
            }
            return one;
        }
        return comparison < 0 ? two : one;
    }

    private boolean isGeneratedModuleDescriptor(ComponentResolveMetaData componentResolveMetaData) {
        return componentResolveMetaData.isGenerated();
    }

    @Override
    public ModuleComponentIdentifier choose(ModuleVersionListing versions, DependencyMetaData dependency, ModuleComponentRepositoryAccess moduleAccess) {
        ModuleVersionSelector requested = dependency.getRequested();
        Collection<SpecRuleAction<? super ComponentSelection>> rules = this.componentSelectionRules.getRules();
        for (Versioned candidate : this.sortLatestFirst(versions)) {
            MetaDataSupplier metaDataSupplier;
            ModuleComponentIdentifier candidateIdentifier = DefaultModuleComponentIdentifier.newId(requested.getGroup(), requested.getName(), candidate.getVersion());
            if (!this.versionMatches(requested, candidateIdentifier, metaDataSupplier = new MetaDataSupplier(dependency, candidateIdentifier, moduleAccess))) continue;
            if (!this.isRejectedByRules(candidateIdentifier, rules, metaDataSupplier)) {
                return candidateIdentifier;
            }
            if (!this.versionMatcher.matchesUniqueVersion(requested.getVersion())) continue;
            break;
        }
        return null;
    }

    private boolean versionMatches(ModuleVersionSelector requested, ModuleComponentIdentifier candidateIdentifier, MetaDataSupplier metaDataSupplier) {
        if (this.versionMatcher.needModuleMetadata(requested.getVersion())) {
            return this.versionMatcher.accept(requested.getVersion(), metaDataSupplier.create());
        }
        return this.versionMatcher.accept(requested.getVersion(), candidateIdentifier.getVersion());
    }

    @Override
    public boolean isRejectedByRules(ModuleComponentIdentifier candidateIdentifier, Factory<? extends MutableModuleComponentResolveMetaData> metaDataSupplier) {
        return this.isRejectedByRules(candidateIdentifier, this.componentSelectionRules.getRules(), metaDataSupplier);
    }

    private boolean isRejectedByRules(ModuleComponentIdentifier candidateIdentifier, Collection<SpecRuleAction<? super ComponentSelection>> rules, Factory<? extends MutableModuleComponentResolveMetaData> metaDataSupplier) {
        DefaultComponentSelection selection = new DefaultComponentSelection(candidateIdentifier);
        this.rulesProcessor.apply(selection, rules, metaDataSupplier);
        return selection.isRejected();
    }

    private List<Versioned> sortLatestFirst(ModuleVersionListing listing) {
        List<Versioned> sorted = this.latestStrategy.sort(listing.getVersions());
        Collections.reverse(sorted);
        return sorted;
    }

    private SpecRuleAction<? super ComponentSelection> createAllSpecRulesAction(RuleAction<? super ComponentSelection> ruleAction) {
        return new SpecRuleAction<ComponentSelection>(ruleAction, Specs.satisfyAll());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataSupplier
    implements Factory<MutableModuleComponentResolveMetaData> {
        private final DependencyMetaData dependency;
        private final ModuleComponentIdentifier id;
        private final ModuleComponentRepositoryAccess repository;

        private MetaDataSupplier(DependencyMetaData dependency, ModuleComponentIdentifier id, ModuleComponentRepositoryAccess repository) {
            this.dependency = dependency;
            this.id = id;
            this.repository = repository;
        }

        public MutableModuleComponentResolveMetaData create() {
            DefaultBuildableModuleComponentMetaDataResolveResult result = new DefaultBuildableModuleComponentMetaDataResolveResult();
            this.repository.resolveComponentMetaData(this.dependency.withRequestedVersion(this.id.getVersion()), this.id, result);
            return result.getMetaData();
        }
    }
}

