/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

public class RepositoryChainAdapter
implements DependencyToComponentIdResolver,
ComponentMetaDataResolver {
    private final DependencyToComponentIdResolver dynamicRevisionResolver;
    private final DependencyToComponentResolver metaDataResolver;
    private final VersionMatcher versionMatcher;

    public RepositoryChainAdapter(DependencyToComponentIdResolver dynamicRevisionResolver, DependencyToComponentResolver metaDataResolver, VersionMatcher versionMatcher) {
        this.dynamicRevisionResolver = dynamicRevisionResolver;
        this.metaDataResolver = metaDataResolver;
        this.versionMatcher = versionMatcher;
    }

    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        ModuleVersionSelector requested = dependency.getRequested();
        if (this.versionMatcher.isDynamic(requested.getVersion())) {
            this.dynamicRevisionResolver.resolve(dependency, result);
        } else {
            DefaultModuleComponentIdentifier id = new DefaultModuleComponentIdentifier(requested.getGroup(), requested.getName(), requested.getVersion());
            DefaultModuleVersionIdentifier mvId = new DefaultModuleVersionIdentifier(requested.getGroup(), requested.getName(), requested.getVersion());
            result.resolved((ComponentIdentifier)id, mvId);
        }
    }

    public void resolve(DependencyMetaData dependency, ComponentIdentifier identifier, BuildableComponentResolveResult result) {
        if (!(identifier instanceof ModuleComponentIdentifier)) {
            throw new UnsupportedOperationException("Can resolve meta-data for module components only.");
        }
        ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)identifier;
        dependency = dependency.withRequestedVersion(new DefaultModuleVersionSelector(moduleId.getGroup(), moduleId.getModule(), moduleId.getVersion()));
        this.metaDataResolver.resolve(dependency, result);
    }
}

