/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DynamicVersionResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.NewestVersionComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainAdapter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentResolver;

public class UserResolverChain
implements RepositoryChain {
    private final RepositoryChainDependencyResolver dependencyResolver;
    private final RepositoryChainArtifactResolver artifactResolver = new RepositoryChainArtifactResolver();
    private final RepositoryChainAdapter adapter;
    private final DynamicVersionResolver dynamicVersionResolver;

    public UserResolverChain(VersionMatcher versionMatcher, LatestStrategy latestStrategy, ComponentSelectionRulesInternal versionSelectionRules) {
        NewestVersionComponentChooser componentChooser = new NewestVersionComponentChooser(latestStrategy, versionMatcher, versionSelectionRules);
        ModuleTransformer metaDataFactory = new ModuleTransformer();
        this.dependencyResolver = new RepositoryChainDependencyResolver(componentChooser, metaDataFactory);
        this.dynamicVersionResolver = new DynamicVersionResolver(componentChooser, metaDataFactory);
        this.adapter = new RepositoryChainAdapter(this.dynamicVersionResolver, this.dependencyResolver, versionMatcher);
    }

    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this.adapter;
    }

    public ComponentMetaDataResolver getComponentMetaDataResolver() {
        return this.adapter;
    }

    public DependencyToComponentResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void add(ModuleComponentRepository repository) {
        this.dependencyResolver.add(repository);
        this.dynamicVersionResolver.add(repository);
        this.artifactResolver.add(repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleTransformer
    implements Transformer<ModuleComponentResolveMetaData, RepositoryChainModuleResolution> {
        private ModuleTransformer() {
        }

        public ModuleComponentResolveMetaData transform(RepositoryChainModuleResolution original) {
            RepositoryChainModuleSource moduleSource = new RepositoryChainModuleSource(original.repository.getId(), original.module.getSource());
            original.module.setSource(moduleSource);
            return original.module;
        }
    }
}

