/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;

public class ExactVersionMatcher
implements VersionMatcher {
    private static final Map<String, Integer> SPECIAL_MEANINGS = ImmutableMap.of((Object)"dev", (Object)new Integer(-1), (Object)"rc", (Object)new Integer(1), (Object)"final", (Object)new Integer(2));

    public boolean canHandle(String selector) {
        return true;
    }

    public boolean isDynamic(String selector) {
        return false;
    }

    public boolean needModuleMetadata(String selector) {
        return false;
    }

    public boolean matchesUniqueVersion(String selector) {
        return true;
    }

    public boolean accept(String selector, String candidate) {
        return selector.equals(candidate);
    }

    public boolean accept(String selector, ModuleComponentResolveMetaData candidate) {
        return this.accept(selector, candidate.getId().getVersion());
    }

    public int compare(String selector, String candidate) {
        int i;
        if (selector.equals(candidate)) {
            return 0;
        }
        selector = selector.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
        selector = selector.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
        candidate = candidate.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
        candidate = candidate.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
        String[] parts1 = selector.split("[\\._\\-\\+]");
        String[] parts2 = candidate.split("[\\._\\-\\+]");
        for (i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (parts1[i].equals(parts2[i])) continue;
            boolean is1Number = this.isNumber(parts1[i]);
            boolean is2Number = this.isNumber(parts2[i]);
            if (is1Number && !is2Number) {
                return 1;
            }
            if (is2Number && !is1Number) {
                return -1;
            }
            if (is1Number && is2Number) {
                return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
            }
            Integer sm1 = SPECIAL_MEANINGS.get(parts1[i].toLowerCase(Locale.US));
            Integer sm2 = SPECIAL_MEANINGS.get(parts2[i].toLowerCase(Locale.US));
            if (sm1 != null) {
                sm2 = sm2 == null ? 0 : sm2;
                return sm1 - sm2;
            }
            if (sm2 != null) {
                return -sm2.intValue();
            }
            return parts1[i].compareTo(parts2[i]);
        }
        if (i < parts1.length) {
            return this.isNumber(parts1[i]) ? 1 : -1;
        }
        if (i < parts2.length) {
            return this.isNumber(parts2[i]) ? -1 : 1;
        }
        return 0;
    }

    private boolean isNumber(String str) {
        return str.matches("\\d+");
    }
}

