/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionMatcher;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;

public class VersionRangeMatcher
implements VersionMatcher {
    private static final String OPEN_INC = "[";
    private static final String OPEN_EXC = "]";
    private static final String OPEN_EXC_MAVEN = "(";
    private static final String CLOSE_INC = "]";
    private static final String CLOSE_EXC = "[";
    private static final String CLOSE_EXC_MAVEN = ")";
    private static final String LOWER_INFINITE = "(";
    private static final String UPPER_INFINITE = ")";
    private static final String SEPARATOR = ",";
    private static final String OPEN_INC_PATTERN = "\\[";
    private static final String OPEN_EXC_PATTERN = "\\]\\(";
    private static final String CLOSE_INC_PATTERN = "\\]";
    private static final String CLOSE_EXC_PATTERN = "\\[\\)";
    private static final String LI_PATTERN = "\\(";
    private static final String UI_PATTERN = "\\)";
    private static final String SEP_PATTERN = "\\s*\\,\\s*";
    private static final String OPEN_PATTERN = "[\\[\\]\\(]";
    private static final String CLOSE_PATTERN = "[\\]\\[\\)]";
    private static final String ANY_NON_SPECIAL_PATTERN = "[^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]";
    private static final String FINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String LOWER_INFINITE_PATTERN = "\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]";
    private static final String UPPER_INFINITE_PATTERN = "[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)";
    private static final Pattern FINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern LOWER_INFINITE_RANGE = Pattern.compile("\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]");
    private static final Pattern UPPER_INFINITE_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private static final Pattern ALL_RANGE = Pattern.compile("[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|\\(\\s*\\,\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*[\\]\\[\\)]|[\\[\\]\\(]\\s*([^\\s,\\[\\]\\(\\]\\[\\)\\(\\)]+)\\s*\\,\\s*\\)");
    private final Comparator<String> staticVersionComparator;

    public VersionRangeMatcher(VersionMatcher staticVersionComparator) {
        this.staticVersionComparator = staticVersionComparator;
    }

    public boolean canHandle(String selector) {
        return ALL_RANGE.matcher(selector).matches();
    }

    public boolean isDynamic(String selector) {
        return true;
    }

    public boolean needModuleMetadata(String selector) {
        return false;
    }

    public boolean matchesUniqueVersion(String selector) {
        return false;
    }

    public boolean accept(String selector, String candidate) {
        Matcher matcher = FINITE_RANGE.matcher(selector);
        if (matcher.matches()) {
            String lower = matcher.group(1);
            String upper = matcher.group(2);
            return this.isHigher(candidate, lower, selector.startsWith("[")) && this.isLower(candidate, upper, selector.endsWith("]"));
        }
        matcher = LOWER_INFINITE_RANGE.matcher(selector);
        if (matcher.matches()) {
            String upper = matcher.group(1);
            return this.isLower(candidate, upper, selector.endsWith("]"));
        }
        matcher = UPPER_INFINITE_RANGE.matcher(selector);
        if (matcher.matches()) {
            String lower = matcher.group(1);
            return this.isHigher(candidate, lower, selector.startsWith("["));
        }
        throw new IllegalArgumentException("Not a version range selector: " + selector);
    }

    public boolean accept(String selector, ModuleComponentResolveMetaData candidate) {
        return this.accept(selector, candidate.getId().getVersion());
    }

    public int compare(String selector, String candidate) {
        String upper;
        Matcher m = UPPER_INFINITE_RANGE.matcher(selector);
        if (m.matches()) {
            return 1;
        }
        m = FINITE_RANGE.matcher(selector);
        if (m.matches()) {
            upper = m.group(2);
        } else {
            m = LOWER_INFINITE_RANGE.matcher(selector);
            if (m.matches()) {
                upper = m.group(1);
            } else {
                throw new IllegalArgumentException("Not a version range selector: " + selector);
            }
        }
        int c = this.staticVersionComparator.compare(upper, candidate);
        return c == 0 ? -1 : c;
    }

    private boolean isLower(String version1, String version2, boolean inclusive) {
        int result = this.staticVersionComparator.compare(version1, version2);
        return result <= (inclusive ? 0 : -1);
    }

    private boolean isHigher(String version1, String version2, boolean inclusive) {
        int result = this.staticVersionComparator.compare(version1, version2);
        return result >= (inclusive ? 0 : 1);
    }
}

