/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.math.BigInteger;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.component.external.model.DefaultIvyModuleResolveMetaData;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.IvyModuleResolveMetaData;
import org.gradle.internal.component.external.model.MavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ModuleSource;

class ModuleDescriptorCacheEntry {
    private static final byte TYPE_MISSING = 0;
    private static final byte TYPE_IVY = 1;
    private static final byte TYPE_MAVEN = 2;
    public byte type;
    public boolean isChanging;
    public String packaging;
    public long createTimestamp;
    public ModuleSource moduleSource;
    public BigInteger moduleDescriptorHash;

    ModuleDescriptorCacheEntry(byte type, boolean isChanging, String packaging, long createTimestamp, BigInteger moduleDescriptorHash, ModuleSource moduleSource) {
        this.type = type;
        this.isChanging = isChanging;
        this.packaging = packaging;
        this.createTimestamp = createTimestamp;
        this.moduleSource = moduleSource;
        this.moduleDescriptorHash = moduleDescriptorHash;
    }

    public static ModuleDescriptorCacheEntry forMissingModule(long createTimestamp) {
        return new ModuleDescriptorCacheEntry(0, false, null, createTimestamp, BigInteger.ZERO, null);
    }

    public static ModuleDescriptorCacheEntry forMetaData(ModuleComponentResolveMetaData metaData, long createTimestamp, BigInteger moduleDescriptorHash) {
        byte type = ModuleDescriptorCacheEntry.getType(metaData);
        String packaging = ModuleDescriptorCacheEntry.getPackaging(metaData);
        return new ModuleDescriptorCacheEntry(type, metaData.isChanging(), packaging, createTimestamp, moduleDescriptorHash, metaData.getSource());
    }

    private static String getPackaging(ModuleComponentResolveMetaData metaData) {
        return metaData instanceof MavenModuleResolveMetaData ? ((MavenModuleResolveMetaData)metaData).getPackaging() : null;
    }

    private static byte getType(ModuleComponentResolveMetaData metaData) {
        if (metaData == null) {
            return 0;
        }
        if (metaData instanceof IvyModuleResolveMetaData) {
            return 1;
        }
        if (metaData instanceof MavenModuleResolveMetaData) {
            return 2;
        }
        throw new IllegalArgumentException("Not a valid module version type: " + metaData);
    }

    public boolean isMissing() {
        return this.type == 0;
    }

    public MutableModuleComponentResolveMetaData createMetaData(ModuleDescriptor descriptor) {
        switch (this.type) {
            case 1: {
                return this.configure(new DefaultIvyModuleResolveMetaData(descriptor));
            }
            case 2: {
                return this.configure(new DefaultMavenModuleResolveMetaData(descriptor, this.packaging, false));
            }
        }
        return null;
    }

    private MutableModuleComponentResolveMetaData configure(MutableModuleComponentResolveMetaData input) {
        input.setChanging(this.isChanging);
        input.setSource(this.moduleSource);
        return input;
    }
}

