/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.component.local.model.MutableLocalComponentMetaData;
import org.gradle.internal.component.local.model.ProjectDependencyMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ModuleToComponentResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDependencyResolver
implements DependencyToComponentIdResolver,
ModuleToComponentResolver {
    private final ProjectComponentRegistry projectComponentRegistry;
    private final DependencyToComponentIdResolver delegate;
    private final LocalComponentFactory localComponentFactory;

    public ProjectDependencyResolver(ProjectComponentRegistry projectComponentRegistry, LocalComponentFactory localComponentFactory, DependencyToComponentIdResolver delegate) {
        this.projectComponentRegistry = projectComponentRegistry;
        this.delegate = delegate;
        this.localComponentFactory = localComponentFactory;
    }

    @Override
    public void resolve(DependencyMetaData dependency, BuildableComponentIdResolveResult result) {
        if (dependency instanceof ProjectDependencyMetaData) {
            ProjectDependencyMetaData projectDependency = (ProjectDependencyMetaData)dependency;
            LocalComponentMetaData componentMetaData = this.projectComponentRegistry.getProject(projectDependency.getSelector().getProjectPath());
            result.resolved(componentMetaData.toResolveMetaData());
        } else {
            this.delegate.resolve(dependency, result);
        }
    }

    @Override
    public void resolve(ModuleInternal module, Set<? extends Configuration> configurations, BuildableComponentResolveResult result) {
        MutableLocalComponentMetaData componentMetaData = this.localComponentFactory.convert(configurations, module);
        result.resolved(componentMetaData.toResolveMetaData());
    }
}

