/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.ConflictResolution;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.cache.ResolutionRules;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.DependencyResolveDetailsInternal;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleVersionSelectorParsers;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultCachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.LatestConflictResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ModuleForcingResolveRule;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.StrictConflictResolution;
import org.gradle.internal.Actions;
import org.gradle.internal.typeconversion.NormalizedTimeUnit;
import org.gradle.internal.typeconversion.TimeUnitsParser;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolutionStrategy
implements ResolutionStrategyInternal {
    private Set<ModuleVersionSelector> forcedModules = new LinkedHashSet<ModuleVersionSelector>();
    private ConflictResolution conflictResolution = new LatestConflictResolution();
    private ComponentSelectionRulesInternal componentSelectionRules = new DefaultComponentSelectionRules();
    final Set<Action<? super DependencyResolveDetails>> dependencyResolveRules;
    private final DefaultCachePolicy cachePolicy;

    public DefaultResolutionStrategy() {
        this(new DefaultCachePolicy(), new LinkedHashSet<Action<? super DependencyResolveDetails>>());
    }

    DefaultResolutionStrategy(DefaultCachePolicy cachePolicy, Set<Action<? super DependencyResolveDetails>> dependencyResolveRules) {
        this.cachePolicy = cachePolicy;
        this.dependencyResolveRules = dependencyResolveRules;
    }

    public Set<ModuleVersionSelector> getForcedModules() {
        return this.forcedModules;
    }

    public ResolutionStrategy failOnVersionConflict() {
        this.conflictResolution = new StrictConflictResolution();
        return this;
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    @Override
    public ResolutionRules getResolutionRules() {
        return this.cachePolicy;
    }

    public DefaultResolutionStrategy force(Object ... moduleVersionSelectorNotations) {
        Set modules = (Set)ModuleVersionSelectorParsers.multiParser().parseNotation((Object)moduleVersionSelectorNotations);
        this.forcedModules.addAll(modules);
        return this;
    }

    public ResolutionStrategy eachDependency(Action<? super DependencyResolveDetails> rule) {
        this.dependencyResolveRules.add(rule);
        return this;
    }

    @Override
    public Action<DependencyResolveDetailsInternal> getDependencyResolveRule() {
        Collection allRules = GUtil.flattenElements((Object[])new Object[]{new ModuleForcingResolveRule(this.forcedModules), this.dependencyResolveRules});
        return Actions.composite((Iterable)allRules);
    }

    public DefaultResolutionStrategy setForcedModules(Object ... moduleVersionSelectorNotations) {
        Set forcedModules;
        this.forcedModules = forcedModules = (Set)ModuleVersionSelectorParsers.multiParser().parseNotation((Object)moduleVersionSelectorNotations);
        return this;
    }

    @Override
    public DefaultCachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void cacheDynamicVersionsFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheDynamicVersionsFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit units) {
        this.cachePolicy.cacheDynamicVersionsFor(value, units);
    }

    public void cacheChangingModulesFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheChangingModulesFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.cachePolicy.cacheChangingModulesFor(value, units);
    }

    @Override
    public ComponentSelectionRulesInternal getComponentSelection() {
        return this.componentSelectionRules;
    }

    public ResolutionStrategy componentSelection(Action<? super ComponentSelectionRules> action) {
        action.execute((Object)this.componentSelectionRules);
        return this;
    }

    @Override
    public DefaultResolutionStrategy copy() {
        DefaultResolutionStrategy out = new DefaultResolutionStrategy(this.cachePolicy.copy(), new LinkedHashSet<Action<? super DependencyResolveDetails>>(this.dependencyResolveRules));
        if (this.conflictResolution instanceof StrictConflictResolution) {
            out.failOnVersionConflict();
        }
        out.setForcedModules(this.getForcedModules());
        out.getComponentSelection().getRules().addAll(this.componentSelectionRules.getRules());
        return out;
    }
}

