/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.List;
import org.apache.ivy.Ivy;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ContextualArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.LocalComponentFactory;
import org.gradle.api.internal.artifacts.ivyservice.VersionForcingDependencyToModuleResolver;
import org.gradle.api.internal.artifacts.ivyservice.clientmodule.ClientModuleResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ErrorHandlingArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChain;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolveIvyFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestStrategy;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.StrictConflictResolution;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DefaultDependencyToConfigurationResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.LatestModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.StrictConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.VersionSelectionReasonResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.StreamingResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.ResolutionResultsStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.api.internal.cache.Store;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyResolver
implements ArtifactDependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependencyResolver.class);
    private final LocalComponentFactory localComponentFactory;
    private final DependencyDescriptorFactory dependencyDescriptorFactory;
    private final ResolveIvyFactory ivyFactory;
    private final ProjectComponentRegistry projectComponentRegistry;
    private final CacheLockingManager cacheLockingManager;
    private final IvyContextManager ivyContextManager;
    private final ResolutionResultsStoreFactory storeFactory;
    private final LatestStrategy latestStrategy;

    public DefaultDependencyResolver(ResolveIvyFactory ivyFactory, LocalComponentFactory localComponentFactory, DependencyDescriptorFactory dependencyDescriptorFactory, ProjectComponentRegistry projectComponentRegistry, CacheLockingManager cacheLockingManager, IvyContextManager ivyContextManager, ResolutionResultsStoreFactory storeFactory, LatestStrategy latestStrategy) {
        this.ivyFactory = ivyFactory;
        this.localComponentFactory = localComponentFactory;
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
        this.projectComponentRegistry = projectComponentRegistry;
        this.cacheLockingManager = cacheLockingManager;
        this.ivyContextManager = ivyContextManager;
        this.storeFactory = storeFactory;
        this.latestStrategy = latestStrategy;
    }

    @Override
    public void resolve(final ConfigurationInternal configuration, final List<? extends ResolutionAwareRepository> repositories, final GlobalDependencyResolutionRules metadataHandler, final ResolverResults results) throws ResolveException {
        LOGGER.debug("Resolving {}", (Object)configuration);
        this.ivyContextManager.withIvy((Action<? super Ivy>)new Action<Ivy>(){

            public void execute(Ivy ivy) {
                RepositoryChain repositoryChain = DefaultDependencyResolver.this.ivyFactory.create(configuration, repositories, metadataHandler.getComponentMetadataProcessor());
                ClientModuleResolver metaDataResolver = new ClientModuleResolver(repositoryChain.getComponentMetaDataResolver(), DefaultDependencyResolver.this.dependencyDescriptorFactory);
                ProjectDependencyResolver projectDependencyResolver = new ProjectDependencyResolver(DefaultDependencyResolver.this.projectComponentRegistry, DefaultDependencyResolver.this.localComponentFactory, repositoryChain.getComponentIdResolver());
                ResolutionStrategyInternal resolutionStrategy = configuration.getResolutionStrategy();
                VersionForcingDependencyToModuleResolver idResolver = new VersionForcingDependencyToModuleResolver(projectDependencyResolver, resolutionStrategy.getDependencyResolveRule());
                ArtifactResolver artifactResolver = DefaultDependencyResolver.this.createArtifactResolver(repositoryChain);
                ModuleConflictResolver conflictResolver = resolutionStrategy.getConflictResolution() instanceof StrictConflictResolution ? new StrictConflictResolver() : new LatestModuleConflictResolver(DefaultDependencyResolver.this.latestStrategy);
                conflictResolver = new VersionSelectionReasonResolver(conflictResolver);
                DefaultConflictHandler conflictHandler = new DefaultConflictHandler(conflictResolver, metadataHandler.getModuleMetadataProcessor().getModuleReplacements());
                DependencyGraphBuilder builder = new DependencyGraphBuilder(idResolver, metaDataResolver, projectDependencyResolver, artifactResolver, conflictHandler, new DefaultDependencyToConfigurationResolver());
                StoreSet stores = DefaultDependencyResolver.this.storeFactory.createStoreSet();
                BinaryStore newModelStore = stores.nextBinaryStore();
                Store<ResolvedComponentResult> newModelCache = stores.oldModelStore();
                StreamingResolutionResultBuilder newModelBuilder = new StreamingResolutionResultBuilder(newModelStore, newModelCache);
                BinaryStore oldModelStore = stores.nextBinaryStore();
                Store<TransientConfigurationResults> oldModelCache = stores.newModelStore();
                TransientConfigurationResultsBuilder oldTransientModelBuilder = new TransientConfigurationResultsBuilder(oldModelStore, oldModelCache);
                DefaultResolvedConfigurationBuilder oldModelBuilder = new DefaultResolvedConfigurationBuilder(oldTransientModelBuilder);
                builder.resolve(configuration, newModelBuilder, oldModelBuilder);
                DefaultLenientConfiguration result = new DefaultLenientConfiguration(configuration, oldModelBuilder, DefaultDependencyResolver.this.cacheLockingManager);
                results.resolved(new DefaultResolvedConfiguration(result), newModelBuilder.complete());
            }
        });
    }

    private ArtifactResolver createArtifactResolver(RepositoryChain repositoryChain) {
        ArtifactResolver artifactResolver = repositoryChain.getArtifactResolver();
        artifactResolver = new ProjectArtifactResolver(artifactResolver);
        artifactResolver = new ContextualArtifactResolver(this.cacheLockingManager, this.ivyContextManager, artifactResolver);
        artifactResolver = new ErrorHandlingArtifactResolver(artifactResolver);
        return artifactResolver;
    }
}

