/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedContentsMapping;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolvedConfigurationBuilder
implements ResolvedConfigurationBuilder,
ResolvedConfigurationResults,
ResolvedContentsMapping {
    private final Map<Long, ResolvedArtifact> artifacts = new LinkedHashMap<Long, ResolvedArtifact>();
    private final Set<UnresolvedDependency> unresolvedDependencies = new LinkedHashSet<UnresolvedDependency>();
    private final IdGenerator<Long> idGenerator = new LongIdGenerator();
    private final Map<ResolvedConfigurationIdentifier, ModuleDependency> modulesMap = new HashMap<ResolvedConfigurationIdentifier, ModuleDependency>();
    private final TransientConfigurationResultsBuilder builder;

    public DefaultResolvedConfigurationBuilder(TransientConfigurationResultsBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void addUnresolvedDependency(UnresolvedDependency unresolvedDependency) {
        this.unresolvedDependencies.add(unresolvedDependency);
    }

    @Override
    public void addFirstLevelDependency(ModuleDependency moduleDependency, ResolvedConfigurationIdentifier dependency) {
        this.builder.firstLevelDependency(dependency);
        this.modulesMap.put(dependency, moduleDependency);
    }

    @Override
    public void done(ResolvedConfigurationIdentifier root) {
        this.builder.done(root);
    }

    @Override
    public void addChild(ResolvedConfigurationIdentifier parent, ResolvedConfigurationIdentifier child) {
        this.builder.parentChildMapping(parent, child);
    }

    @Override
    public void addParentSpecificArtifacts(ResolvedConfigurationIdentifier child, ResolvedConfigurationIdentifier parent, Set<ResolvedArtifact> artifacts) {
        for (ResolvedArtifact a : artifacts) {
            this.builder.parentSpecificArtifact(child, parent, ((DefaultResolvedArtifact)a).getId());
        }
    }

    @Override
    public void newResolvedDependency(ResolvedConfigurationIdentifier id) {
        this.builder.resolvedDependency(id);
    }

    @Override
    public ResolvedArtifact newArtifact(ResolvedConfigurationIdentifier owner, ComponentResolveMetaData component, ComponentArtifactMetaData artifact, ArtifactResolver artifactResolver) {
        LazyArtifactSource artifactSource = new LazyArtifactSource(artifact, component.getSource(), artifactResolver);
        long id = (Long)this.idGenerator.generateId();
        DefaultResolvedArtifact newArtifact = new DefaultResolvedArtifact(new DefaultResolvedModuleVersion(owner.getId()), artifact.getName(), artifactSource, id);
        this.artifacts.put(id, newArtifact);
        return newArtifact;
    }

    @Override
    public boolean hasError() {
        return !this.unresolvedDependencies.isEmpty();
    }

    @Override
    public TransientConfigurationResults more() {
        return this.builder.load(this);
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        return new LinkedHashSet<ResolvedArtifact>(this.artifacts.values());
    }

    @Override
    public ResolvedArtifact getArtifact(long artifactId) {
        ResolvedArtifact a = this.artifacts.get(artifactId);
        assert (a != null) : "Unable to find artifact for id: " + artifactId;
        return a;
    }

    @Override
    public ModuleDependency getModuleDependency(ResolvedConfigurationIdentifier id) {
        ModuleDependency m = this.modulesMap.get(id);
        assert (m != null) : "Unable to find module dependency for id: " + id;
        return m;
    }

    @Override
    public Set<UnresolvedDependency> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyArtifactSource
    implements Factory<File> {
        private final ArtifactResolver artifactResolver;
        private final ModuleSource moduleSource;
        private final ComponentArtifactMetaData artifact;

        private LazyArtifactSource(ComponentArtifactMetaData artifact, ModuleSource moduleSource, ArtifactResolver artifactResolver) {
            this.artifact = artifact;
            this.artifactResolver = artifactResolver;
            this.moduleSource = moduleSource;
        }

        public File create() {
            DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.artifact, this.moduleSource, result);
            return result.getFile();
        }
    }
}

