/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIdentifierSerializer
implements Serializer<ComponentIdentifier> {
    public ComponentIdentifier read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.BUILD.getId() == id) {
            return new DefaultProjectComponentIdentifier(decoder.readString());
        }
        if (Implementation.MODULE.getId() == id) {
            return new DefaultModuleComponentIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
        }
        throw new IllegalArgumentException("Unable to find component identifier with id: " + id);
    }

    public void write(Encoder encoder, ComponentIdentifier value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component identifier may not be null");
        }
        if (value instanceof DefaultModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)value;
            encoder.writeByte(Implementation.MODULE.getId());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getGroup());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getModule());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getVersion());
        } else if (value instanceof DefaultProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
            encoder.writeByte(Implementation.BUILD.getId());
            encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
        } else {
            throw new IllegalArgumentException("Unsupported component identifier class: " + value.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Implementation {
        MODULE(1),
        BUILD(2);

        private final byte id;

        private Implementation(byte id) {
            this.id = id;
        }

        private byte getId() {
            return this.id;
        }
    }
}

