/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSelectorSerializer
implements Serializer<ComponentSelector> {
    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.BUILD.getId() == id) {
            return new DefaultProjectComponentSelector(decoder.readString());
        }
        if (Implementation.MODULE.getId() == id) {
            return new DefaultModuleComponentSelector(decoder.readString(), decoder.readString(), decoder.readString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        if (value instanceof DefaultModuleComponentSelector) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)value;
            encoder.writeByte(Implementation.MODULE.getId());
            encoder.writeString((CharSequence)moduleComponentSelector.getGroup());
            encoder.writeString((CharSequence)moduleComponentSelector.getModule());
            encoder.writeString((CharSequence)moduleComponentSelector.getVersion());
        } else if (value instanceof DefaultProjectComponentSelector) {
            ProjectComponentSelector projectComponentSelector = (ProjectComponentSelector)value;
            encoder.writeByte(Implementation.BUILD.getId());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
        } else {
            throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Implementation {
        MODULE(1),
        BUILD(2);

        private final byte id;

        private Implementation(byte id) {
            this.id = id;
        }

        private byte getId() {
            return this.id;
        }
    }
}

