/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.Map;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultInternalDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.InternalDependencyResult;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalDependencyResultSerializer {
    private static final byte SUCCESSFUL = 0;
    private static final byte FAILED = 1;
    private final ComponentSelectorSerializer componentSelectorSerializer = new ComponentSelectorSerializer();
    private final ComponentSelectionReasonSerializer componentSelectionReasonSerializer = new ComponentSelectionReasonSerializer();
    private final ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer = new ModuleVersionIdentifierSerializer();

    public InternalDependencyResult read(Decoder decoder, Map<ComponentSelector, ModuleVersionResolveException> failures) throws IOException {
        ComponentSelector requested = this.componentSelectorSerializer.read(decoder);
        byte resultByte = decoder.readByte();
        if (resultByte == 0) {
            ModuleVersionIdentifier selected = this.moduleVersionIdentifierSerializer.read(decoder);
            return new DefaultInternalDependencyResult(requested, selected, null, null);
        }
        if (resultByte == 1) {
            ComponentSelectionReason reason = this.componentSelectionReasonSerializer.read(decoder);
            ModuleVersionResolveException failure = failures.get(requested);
            return new DefaultInternalDependencyResult(requested, null, reason, failure);
        }
        throw new IllegalArgumentException("Unknown result byte: " + resultByte);
    }

    public void write(Encoder encoder, InternalDependencyResult value) throws IOException {
        this.componentSelectorSerializer.write(encoder, value.getRequested());
        if (value.getFailure() == null) {
            encoder.writeByte((byte)0);
            this.moduleVersionIdentifierSerializer.write(encoder, value.getSelected());
        } else {
            encoder.writeByte((byte)1);
            this.componentSelectionReasonSerializer.write(encoder, value.getReason());
        }
    }
}

