/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.net.URI;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.AbstractResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.resource.ExternalResourceName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ResourcePattern
extends AbstractResourcePattern {
    public M2ResourcePattern(String pattern) {
        super(pattern);
    }

    public M2ResourcePattern(URI baseUri, String pattern) {
        super(baseUri, pattern);
    }

    public String toString() {
        return String.format("M2 pattern '%s'", this.getPattern());
    }

    @Override
    public ExternalResourceName getLocation(ModuleComponentArtifactMetaData artifact) {
        Map<String, String> attributes = this.toAttributes(artifact);
        String pattern = this.maybeSubstituteTimestamp(artifact, this.getBase().getPath());
        return this.getBase().getRoot().resolve(this.substituteTokens(pattern, attributes));
    }

    private String maybeSubstituteTimestamp(ModuleComponentArtifactMetaData artifact, String pattern) {
        if (artifact.getComponentId() instanceof MavenUniqueSnapshotComponentIdentifier) {
            String timestampedVersion = ((MavenUniqueSnapshotComponentIdentifier)artifact.getComponentId()).getTimestampedVersion();
            pattern = pattern.replaceFirst("\\-\\[revision\\]", "-" + timestampedVersion);
        }
        return pattern;
    }

    @Override
    public ExternalResourceName toVersionListPattern(ModuleIdentifier module, IvyArtifactName artifact) {
        Map<String, String> attributes = this.toAttributes(module, artifact);
        return this.getBase().getRoot().resolve(this.substituteTokens(this.getBase().getPath(), attributes));
    }

    @Override
    public ExternalResourceName toModulePath(ModuleIdentifier module) {
        String pattern = this.getBase().getPath();
        if (!pattern.endsWith("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]")) {
            throw new UnsupportedOperationException("Cannot locate module for non-maven layout.");
        }
        String metaDataPattern = pattern.substring(0, pattern.length() - "[revision]/[artifact]-[revision](-[classifier]).[ext]".length() - 1);
        return this.getBase().getRoot().resolve(this.substituteTokens(metaDataPattern, this.toAttributes(module)));
    }

    @Override
    public ExternalResourceName toModuleVersionPath(ModuleComponentIdentifier componentIdentifier) {
        String pattern = this.getBase().getPath();
        if (!pattern.endsWith("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]")) {
            throw new UnsupportedOperationException("Cannot locate module version for non-maven layout.");
        }
        String metaDataPattern = pattern.substring(0, pattern.length() - "[artifact]-[revision](-[classifier]).[ext]".length() - 1);
        return this.getBase().getRoot().resolve(this.substituteTokens(metaDataPattern, this.toAttributes(componentIdentifier)));
    }

    @Override
    protected String substituteTokens(String pattern, Map<String, String> attributes) {
        String org = attributes.get("organisation");
        if (org != null) {
            attributes.put("organisation", org.replace(".", "/"));
        }
        return super.substituteTokens(pattern, attributes);
    }
}

