/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.repositories.resolver.ChainedVersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotModuleSource;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenVersionLister;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourceVersionLister;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Transformers;
import org.gradle.internal.component.external.model.DefaultMavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.MavenModuleResolveMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.LocallyAvailableExternalResource;
import org.gradle.internal.resource.ResourceNotFoundException;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenResolver
extends ExternalResourceResolver {
    private final URI root;
    private final List<URI> artifactRoots = new ArrayList<URI>();
    private final MavenMetadataLoader mavenMetaDataLoader;
    private final MetaDataParser metaDataParser = new GradlePomModuleDescriptorParser();

    public MavenResolver(String name, URI rootUri, RepositoryTransport transport, LocallyAvailableResourceFinder<ModuleComponentArtifactMetaData> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactMetaData> artifactFileStore) {
        super(name, transport.isLocal(), transport.getRepository(), transport.getResourceAccessor(), new ChainedVersionLister(new MavenVersionLister(transport.getRepository()), new ResourceVersionLister(transport.getRepository())), locallyAvailableResourceFinder, artifactFileStore);
        this.mavenMetaDataLoader = new MavenMetadataLoader(transport.getRepository());
        this.root = rootUri;
        this.updatePatterns();
    }

    public String toString() {
        return String.format("Maven repository '%s'", this.getName());
    }

    public URI getRoot() {
        return this.root;
    }

    @Override
    protected void doResolveComponentMetaData(DependencyMetaData dependency, ModuleComponentIdentifier moduleComponentIdentifier, BuildableModuleComponentMetaDataResolveResult result) {
        MavenUniqueSnapshotModuleSource uniqueSnapshotVersion;
        if (this.isSnapshotVersion(moduleComponentIdentifier) && (uniqueSnapshotVersion = this.findUniqueSnapshotVersion(moduleComponentIdentifier, result)) != null) {
            this.resolveUniqueSnapshotDependency(dependency, moduleComponentIdentifier, result, uniqueSnapshotVersion);
            return;
        }
        this.resolveStaticDependency(dependency, moduleComponentIdentifier, result, super.createArtifactResolver());
    }

    @Override
    protected boolean isMetaDataArtifact(ArtifactType artifactType) {
        return artifactType == ArtifactType.MAVEN_POM;
    }

    @Override
    protected MutableModuleComponentResolveMetaData processMetaData(MutableModuleComponentResolveMetaData metaData) {
        if (metaData.getId().getVersion().endsWith("-SNAPSHOT")) {
            metaData.setChanging(true);
        }
        return metaData;
    }

    private void resolveUniqueSnapshotDependency(DependencyMetaData dependency, ModuleComponentIdentifier module, BuildableModuleComponentMetaDataResolveResult result, MavenUniqueSnapshotModuleSource snapshotSource) {
        this.resolveStaticDependency(dependency, module, result, this.createArtifactResolver(snapshotSource));
        if (result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            result.getMetaData().setSource(snapshotSource);
        }
    }

    private boolean isSnapshotVersion(ModuleComponentIdentifier module) {
        return module.getVersion().endsWith("-SNAPSHOT");
    }

    @Override
    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSource moduleSource) {
        if (moduleSource instanceof MavenUniqueSnapshotModuleSource) {
            String timestamp = ((MavenUniqueSnapshotModuleSource)moduleSource).getTimestamp();
            return new MavenUniqueSnapshotExternalResourceArtifactResolver(super.createArtifactResolver(moduleSource), timestamp);
        }
        return super.createArtifactResolver(moduleSource);
    }

    public void addArtifactLocation(URI baseUri) {
        this.artifactRoots.add(baseUri);
        this.updatePatterns();
    }

    private M2ResourcePattern getWholePattern() {
        return new M2ResourcePattern(this.root, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]");
    }

    private void updatePatterns() {
        this.setIvyPatterns(Collections.singletonList(this.getWholePattern()));
        ArrayList<ResourcePattern> artifactPatterns = new ArrayList<ResourcePattern>();
        artifactPatterns.add(this.getWholePattern());
        for (URI artifactRoot : this.artifactRoots) {
            artifactPatterns.add(new M2ResourcePattern(artifactRoot, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]"));
        }
        this.setArtifactPatterns(artifactPatterns);
    }

    @Override
    protected IvyArtifactName getMetaDataArtifactName(String moduleName) {
        return new DefaultIvyArtifactName(moduleName, "pom", "pom");
    }

    private MavenUniqueSnapshotModuleSource findUniqueSnapshotVersion(ModuleComponentIdentifier module, ResourceAwareResolveResult result) {
        ExternalResourceName metadataLocation = this.getWholePattern().toModuleVersionPath(module).resolve("maven-metadata.xml");
        result.attempted(metadataLocation);
        MavenMetadata mavenMetadata = this.parseMavenMetadata(metadataLocation.getUri());
        if (mavenMetadata.timestamp != null) {
            String timestamp = String.format("%s-%s", mavenMetadata.timestamp, mavenMetadata.buildNumber);
            return new MavenUniqueSnapshotModuleSource(timestamp);
        }
        return null;
    }

    private MavenMetadata parseMavenMetadata(URI metadataLocation) {
        try {
            return this.mavenMetaDataLoader.load(metadataLocation);
        }
        catch (ResourceNotFoundException e) {
            return new MavenMetadata();
        }
    }

    @Override
    public boolean isM2compatible() {
        return true;
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return new MavenLocalRepositoryAccess();
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return new MavenRemoteRepositoryAccess();
    }

    @Override
    protected MutableModuleComponentResolveMetaData createMetaDataForDependency(DependencyMetaData dependency) {
        return new DefaultMavenModuleResolveMetaData(dependency);
    }

    @Override
    protected MutableModuleComponentResolveMetaData parseMetaDataFromResource(LocallyAvailableExternalResource cachedResource, DescriptorParseContext context) {
        return this.metaDataParser.parseMetaData(context, cachedResource);
    }

    protected static MavenModuleResolveMetaData mavenMetaData(ModuleComponentResolveMetaData metaData) {
        return (MavenModuleResolveMetaData)Transformers.cast(MavenModuleResolveMetaData.class).transform((Object)metaData);
    }

    private class MavenRemoteRepositoryAccess
    extends ExternalResourceResolver.RemoteRepositoryAccess {
        private MavenRemoteRepositoryAccess() {
            super(MavenResolver.this);
        }

        protected void resolveConfigurationArtifacts(ModuleComponentResolveMetaData module, ConfigurationMetaData configuration, BuildableArtifactSetResolveResult result) {
            MavenModuleResolveMetaData mavenMetaData = MavenResolver.mavenMetaData(module);
            if (mavenMetaData.isPomPackaging()) {
                LinkedHashSet<ModuleComponentArtifactMetaData> artifacts = new LinkedHashSet<ModuleComponentArtifactMetaData>();
                artifacts.addAll(MavenResolver.this.findOptionalArtifacts(module, "jar", null));
                result.resolved(artifacts);
            } else {
                ModuleComponentArtifactMetaData artifactMetaData = module.artifact(mavenMetaData.getPackaging(), mavenMetaData.getPackaging(), null);
                if (MavenResolver.this.createArtifactResolver(module.getSource()).artifactExists(artifactMetaData, new DefaultResourceAwareResolveResult())) {
                    result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifactMetaData));
                } else {
                    ModuleComponentArtifactMetaData artifact = module.artifact("jar", "jar", null);
                    result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifact));
                }
            }
        }

        protected void resolveJavadocArtifacts(ModuleComponentResolveMetaData module, BuildableArtifactSetResolveResult result) {
            result.resolved(MavenResolver.this.findOptionalArtifacts(module, "javadoc", "javadoc"));
        }

        protected void resolveSourceArtifacts(ModuleComponentResolveMetaData module, BuildableArtifactSetResolveResult result) {
            result.resolved(MavenResolver.this.findOptionalArtifacts(module, "source", "sources"));
        }
    }

    private class MavenLocalRepositoryAccess
    extends ExternalResourceResolver.LocalRepositoryAccess {
        private MavenLocalRepositoryAccess() {
            super(MavenResolver.this);
        }

        protected void resolveConfigurationArtifacts(ModuleComponentResolveMetaData module, ConfigurationMetaData configuration, BuildableArtifactSetResolveResult result) {
            if (MavenResolver.mavenMetaData(module).isKnownJarPackaging()) {
                ModuleComponentArtifactMetaData artifact = module.artifact("jar", "jar", null);
                result.resolved((Collection<? extends ComponentArtifactMetaData>)ImmutableSet.of((Object)artifact));
            }
        }

        protected void resolveJavadocArtifacts(ModuleComponentResolveMetaData module, BuildableArtifactSetResolveResult result) {
        }

        protected void resolveSourceArtifacts(ModuleComponentResolveMetaData module, BuildableArtifactSetResolveResult result) {
        }
    }
}

