/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.transport.file.FileTransport;
import org.gradle.internal.resource.transport.http.HttpTransport;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpTransport;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.BuildCommencedTimeProvider;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTransportFactory {
    private final TemporaryFileProvider temporaryFileProvider;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildCommencedTimeProvider timeProvider;
    private final SftpClientFactory sftpClientFactory;
    private final CacheLockingManager cacheLockingManager;

    public RepositoryTransportFactory(ProgressLoggerFactory progressLoggerFactory, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, SftpClientFactory sftpClientFactory, CacheLockingManager cacheLockingManager) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.sftpClientFactory = sftpClientFactory;
        this.cacheLockingManager = cacheLockingManager;
    }

    private RepositoryTransport createHttpTransport(String name, org.gradle.api.artifacts.repositories.PasswordCredentials credentials) {
        return new HttpTransport(name, this.convertPasswordCredentials(credentials), this.progressLoggerFactory, this.temporaryFileProvider, this.cachedExternalResourceIndex, this.timeProvider, this.cacheLockingManager);
    }

    private RepositoryTransport createFileTransport(String name) {
        return new FileTransport(name);
    }

    private RepositoryTransport createSftpTransport(String name, org.gradle.api.artifacts.repositories.PasswordCredentials credentials) {
        return new SftpTransport(name, this.convertPasswordCredentials(credentials), this.progressLoggerFactory, this.temporaryFileProvider, this.cachedExternalResourceIndex, this.timeProvider, this.sftpClientFactory, this.cacheLockingManager);
    }

    public RepositoryTransport createTransport(String scheme, String name, org.gradle.api.artifacts.repositories.PasswordCredentials credentials) {
        HashSet<String> schemes = new HashSet<String>();
        schemes.add(scheme);
        return this.createTransport(schemes, name, credentials);
    }

    private PasswordCredentials convertPasswordCredentials(org.gradle.api.artifacts.repositories.PasswordCredentials credentials) {
        return new PasswordCredentials(credentials.getUsername(), credentials.getPassword());
    }

    public RepositoryTransport createTransport(Set<String> schemes, String name, org.gradle.api.artifacts.repositories.PasswordCredentials credentials) {
        if (!WrapUtil.toSet((Object[])new String[]{"http", "https", "file", "sftp"}).containsAll(schemes)) {
            throw new InvalidUserDataException("You may only specify 'file', 'http', 'https' and 'sftp' URLs for a repository.");
        }
        if (WrapUtil.toSet((Object[])new String[]{"http", "https"}).containsAll(schemes)) {
            return this.createHttpTransport(name, credentials);
        }
        if (WrapUtil.toSet((Object[])new String[]{"file"}).containsAll(schemes)) {
            return this.createFileTransport(name);
        }
        if (WrapUtil.toSet((Object[])new String[]{"sftp"}).containsAll(schemes)) {
            return this.createSftpTransport(name, credentials);
        }
        throw new InvalidUserDataException("You cannot mix different URL schemes for a single repository. Please declare separate repositories.");
    }
}

