/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.component.model.AbstractModuleDescriptorBackedMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.ModuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractModuleComponentResolveMetaData
extends AbstractModuleDescriptorBackedMetaData
implements MutableModuleComponentResolveMetaData {
    private Set<ModuleComponentArtifactMetaData> artifacts;
    private Multimap<String, ModuleComponentArtifactMetaData> artifactsByConfig;

    public AbstractModuleComponentResolveMetaData(ModuleDescriptor moduleDescriptor) {
        this(AbstractModuleComponentResolveMetaData.moduleVersionIdentifier(moduleDescriptor), moduleDescriptor, AbstractModuleComponentResolveMetaData.moduleComponentIdentifier(moduleDescriptor));
    }

    private static ModuleVersionIdentifier moduleVersionIdentifier(ModuleDescriptor descriptor) {
        return DefaultModuleVersionIdentifier.newId(descriptor.getModuleRevisionId());
    }

    private static ModuleComponentIdentifier moduleComponentIdentifier(ModuleDescriptor descriptor) {
        return DefaultModuleComponentIdentifier.newId(AbstractModuleComponentResolveMetaData.moduleVersionIdentifier(descriptor));
    }

    public AbstractModuleComponentResolveMetaData(ModuleVersionIdentifier moduleVersionIdentifier, ModuleDescriptor moduleDescriptor, ModuleComponentIdentifier componentIdentifier) {
        super(moduleVersionIdentifier, moduleDescriptor, (ComponentIdentifier)componentIdentifier);
    }

    protected void copyTo(AbstractModuleComponentResolveMetaData copy) {
        super.copyTo(copy);
        copy.artifacts = this.artifacts;
        copy.artifactsByConfig = this.artifactsByConfig;
    }

    @Override
    public abstract AbstractModuleComponentResolveMetaData copy();

    @Override
    public MutableModuleComponentResolveMetaData withSource(ModuleSource source) {
        AbstractModuleComponentResolveMetaData copy = this.copy();
        copy.setModuleSource(source);
        return copy;
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return (ModuleComponentIdentifier)super.getComponentId();
    }

    @Override
    public ModuleComponentArtifactMetaData artifact(Artifact artifact) {
        return new DefaultModuleComponentArtifactMetaData(this.getComponentId(), artifact);
    }

    @Override
    public ModuleComponentArtifactMetaData artifact(String type, @Nullable String extension, @Nullable String classifier) {
        Map extraAttributes = classifier == null ? Collections.emptyMap() : Collections.singletonMap("m:classifier", classifier);
        DefaultArtifact artifact = new DefaultArtifact(this.getDescriptor().getModuleRevisionId(), null, this.getId().getName(), type, extension, extraAttributes);
        return new DefaultModuleComponentArtifactMetaData(this.getComponentId(), (Artifact)artifact);
    }

    @Override
    public Set<ModuleComponentArtifactMetaData> getArtifacts() {
        if (this.artifacts == null) {
            this.populateArtifactsFromDescriptor();
        }
        return this.artifacts;
    }

    @Override
    public void setArtifacts(Iterable<? extends ModuleComponentArtifactMetaData> artifacts) {
        this.artifacts = Sets.newLinkedHashSet(artifacts);
        this.artifactsByConfig = LinkedHashMultimap.create();
        for (String config : this.getDescriptor().getConfigurationsNames()) {
            this.artifactsByConfig.putAll((Object)config, artifacts);
        }
    }

    @Override
    protected Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData configurationMetaData) {
        if (this.artifactsByConfig == null) {
            this.populateArtifactsFromDescriptor();
        }
        LinkedHashSet<ComponentArtifactMetaData> artifactMetaData = new LinkedHashSet<ComponentArtifactMetaData>();
        for (String ancestor : configurationMetaData.getHierarchy()) {
            artifactMetaData.addAll(this.artifactsByConfig.get((Object)ancestor));
        }
        return artifactMetaData;
    }

    private void populateArtifactsFromDescriptor() {
        LinkedHashMap artifactToMetaData = Maps.newLinkedHashMap();
        for (Artifact artifact : this.getDescriptor().getAllArtifacts()) {
            ModuleComponentArtifactMetaData artifact2 = this.artifact(artifact);
            artifactToMetaData.put(artifact, artifact2);
        }
        this.artifacts = Sets.newLinkedHashSet(artifactToMetaData.values());
        this.artifactsByConfig = LinkedHashMultimap.create();
        for (String string : this.getDescriptor().getConfigurationsNames()) {
            Artifact[] configArtifacts;
            for (Artifact configArtifact : configArtifacts = this.getDescriptor().getArtifacts(string)) {
                this.artifactsByConfig.put((Object)string, artifactToMetaData.get(configArtifact));
            }
        }
    }
}

