/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetaData;
import org.gradle.internal.component.external.model.MavenModuleResolveMetaData;
import org.gradle.internal.component.model.DependencyMetaData;

public class DefaultMavenModuleResolveMetaData
extends AbstractModuleComponentResolveMetaData
implements MavenModuleResolveMetaData {
    private static final String POM_PACKAGING = "pom";
    private static final Collection<String> JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private final String packaging;
    private final boolean relocated;

    public DefaultMavenModuleResolveMetaData(ModuleDescriptor moduleDescriptor, String packaging, boolean relocated) {
        super(moduleDescriptor);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    public DefaultMavenModuleResolveMetaData(ModuleVersionIdentifier id, ModuleDescriptor descriptor, ModuleComponentIdentifier componentId, String packaging, boolean relocated) {
        super(id, descriptor, componentId);
        this.packaging = packaging;
        this.relocated = relocated;
    }

    public DefaultMavenModuleResolveMetaData(DependencyMetaData dependencyMetaData) {
        this((ModuleDescriptor)IvyUtil.createModuleDescriptor(dependencyMetaData.getDescriptor()), "jar", false);
    }

    public DefaultMavenModuleResolveMetaData copy() {
        DefaultMavenModuleResolveMetaData copy = new DefaultMavenModuleResolveMetaData(this.getId(), this.getDescriptor(), this.getComponentId(), this.packaging, this.relocated);
        this.copyTo(copy);
        return copy;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    public boolean isKnownJarPackaging() {
        return "jar".equals(this.packaging) || JAR_PACKAGINGS.contains(this.packaging);
    }
}

