/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;

public class DefaultModuleComponentIdentifier
implements ModuleComponentIdentifier {
    private final String displayName;
    private final String group;
    private final String module;
    private final String version;

    public DefaultModuleComponentIdentifier(String group, String module, String version) {
        assert (group != null) : "group cannot be null";
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        this.displayName = String.format("%s:%s:%s", group, module, version);
        this.group = group;
        this.module = module;
        this.version = version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentIdentifier that = (DefaultModuleComponentIdentifier)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.module.equals(that.module)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.displayName;
    }

    public static ModuleComponentIdentifier newId(String group, String name, String version) {
        return new DefaultModuleComponentIdentifier(group, name, version);
    }

    public static ModuleComponentIdentifier newId(ModuleVersionIdentifier moduleVersionIdentifier) {
        return new DefaultModuleComponentIdentifier(moduleVersionIdentifier.getGroup(), moduleVersionIdentifier.getName(), moduleVersionIdentifier.getVersion());
    }
}

