/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector {
    private final String displayName;
    private final String group;
    private final String module;
    private final String version;

    public DefaultModuleComponentSelector(String group, String module, String version) {
        assert (group != null) : "group cannot be null";
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        this.displayName = String.format("%s:%s:%s", group, module, version);
        this.group = group;
        this.module = module;
        this.version = version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.module.equals(moduleComponentIdentifier.getModule()) && this.group.equals(moduleComponentIdentifier.getGroup()) && this.version.equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.module.equals(that.module)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.displayName;
    }

    public static ModuleComponentSelector newSelector(String group, String name, String version) {
        return new DefaultModuleComponentSelector(group, name, version);
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getGroup(), selector.getName(), selector.getVersion());
    }
}

