/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetaData;
import org.gradle.internal.component.local.model.DefaultLocalArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalArtifactMetaData;
import org.gradle.internal.component.local.model.MutableLocalComponentMetaData;
import org.gradle.internal.component.model.AbstractModuleDescriptorBackedMetaData;
import org.gradle.internal.component.model.ComponentArtifactIdentifier;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.component.model.ConfigurationMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocalComponentMetaData
implements MutableLocalComponentMetaData {
    private final Map<ComponentArtifactIdentifier, DefaultLocalArtifactMetaData> artifactsById = new LinkedHashMap<ComponentArtifactIdentifier, DefaultLocalArtifactMetaData>();
    private final Map<ArtifactRevisionId, DefaultLocalArtifactMetaData> artifactsByIvyId = new LinkedHashMap<ArtifactRevisionId, DefaultLocalArtifactMetaData>();
    private final Multimap<String, DefaultLocalArtifactMetaData> artifactsByConfig = LinkedHashMultimap.create();
    private final List<DependencyMetaData> dependencies = new ArrayList<DependencyMetaData>();
    private final DefaultModuleDescriptor moduleDescriptor;
    private final ModuleVersionIdentifier id;
    private final ComponentIdentifier componentIdentifier;

    public DefaultLocalComponentMetaData(DefaultModuleDescriptor moduleDescriptor, ComponentIdentifier componentIdentifier) {
        this.moduleDescriptor = moduleDescriptor;
        this.id = DefaultModuleVersionIdentifier.newId(moduleDescriptor.getModuleRevisionId());
        this.componentIdentifier = componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public void addArtifact(String configuration, IvyArtifactName artifact, File file) {
        MDArtifact ivyArtifact = new MDArtifact((ModuleDescriptor)this.moduleDescriptor, artifact.getName(), artifact.getType(), artifact.getExtension(), null, artifact.getAttributes());
        DefaultLocalArtifactMetaData artifactMetaData = new DefaultLocalArtifactMetaData(this.componentIdentifier, this.id.toString(), (Artifact)ivyArtifact, file);
        if (this.artifactsById.containsKey(artifactMetaData.getId())) {
            artifactMetaData = this.artifactsById.get(artifactMetaData.getId());
        } else {
            this.artifactsById.put(artifactMetaData.id, artifactMetaData);
            this.artifactsByIvyId.put(ivyArtifact.getId(), artifactMetaData);
        }
        this.moduleDescriptor.addArtifact(configuration, (Artifact)ivyArtifact);
        this.artifactsByConfig.put((Object)configuration, (Object)artifactMetaData);
        ((MDArtifact)artifactMetaData.artifact).addConfiguration(configuration);
    }

    @Override
    public void addConfiguration(String name, boolean visible, String description, String[] superConfigs, boolean transitive) {
        this.moduleDescriptor.addConfiguration(new Configuration(name, visible ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE, description, superConfigs, transitive, null));
    }

    @Override
    public void addDependency(DependencyMetaData dependency) {
        this.dependencies.add(dependency);
        this.moduleDescriptor.addDependency(dependency.getDescriptor());
    }

    @Override
    public void addExcludeRule(ExcludeRule excludeRule) {
        this.moduleDescriptor.addExcludeRule(excludeRule);
    }

    public Collection<? extends LocalArtifactMetaData> getArtifacts() {
        return this.artifactsById.values();
    }

    @Override
    public LocalArtifactMetaData getArtifact(ComponentArtifactIdentifier artifactIdentifier) {
        return this.artifactsById.get(artifactIdentifier);
    }

    @Override
    public ComponentResolveMetaData toResolveMetaData() {
        return new LocalComponentResolveMetaData();
    }

    @Override
    public BuildableIvyModulePublishMetaData toPublishMetaData() {
        DefaultIvyModulePublishMetaData publishMetaData = new DefaultIvyModulePublishMetaData(this.id);
        for (DefaultLocalArtifactMetaData artifact : this.artifactsById.values()) {
            publishMetaData.addArtifact(artifact.artifact, artifact.file);
        }
        return publishMetaData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalComponentResolveMetaData
    extends AbstractModuleDescriptorBackedMetaData {
        public LocalComponentResolveMetaData() {
            super(DefaultLocalComponentMetaData.this.id, (ModuleDescriptor)DefaultLocalComponentMetaData.this.moduleDescriptor, DefaultLocalComponentMetaData.this.componentIdentifier);
        }

        @Override
        public ModuleComponentResolveMetaData withSource(ModuleSource source) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected List<DependencyMetaData> populateDependenciesFromDescriptor() {
            return DefaultLocalComponentMetaData.this.dependencies;
        }

        @Override
        public ComponentArtifactMetaData artifact(Artifact artifact) {
            DefaultLocalArtifactMetaData candidate = (DefaultLocalArtifactMetaData)DefaultLocalComponentMetaData.this.artifactsByIvyId.get(artifact.getId());
            return candidate != null ? candidate : new DefaultLocalArtifactMetaData(DefaultLocalComponentMetaData.this.componentIdentifier, DefaultLocalComponentMetaData.this.id.toString(), artifact, null);
        }

        public Set<ComponentArtifactMetaData> getArtifacts() {
            return new LinkedHashSet<ComponentArtifactMetaData>(DefaultLocalComponentMetaData.this.artifactsById.values());
        }

        @Override
        protected Set<ComponentArtifactMetaData> getArtifactsForConfiguration(ConfigurationMetaData configurationMetaData) {
            LinkedHashSet<ComponentArtifactMetaData> result = new LinkedHashSet<ComponentArtifactMetaData>();
            HashSet<DefaultLocalArtifactIdentifier> seen = new HashSet<DefaultLocalArtifactIdentifier>();
            for (String configName : configurationMetaData.getHierarchy()) {
                for (DefaultLocalArtifactMetaData localArtifactMetaData : DefaultLocalComponentMetaData.this.artifactsByConfig.get((Object)configName)) {
                    if (!seen.add(localArtifactMetaData.id)) continue;
                    result.add(localArtifactMetaData);
                }
            }
            return result;
        }
    }

    private static class DefaultLocalArtifactMetaData
    implements LocalArtifactMetaData {
        private final ComponentIdentifier componentIdentifier;
        private final DefaultLocalArtifactIdentifier id;
        private final Artifact artifact;
        private final File file;

        private DefaultLocalArtifactMetaData(ComponentIdentifier componentIdentifier, String displayName, Artifact artifact, File file) {
            this.componentIdentifier = componentIdentifier;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.putAll(artifact.getExtraAttributes());
            attrs.put("file", file == null ? "null" : file.getAbsolutePath());
            this.id = new DefaultLocalArtifactIdentifier(componentIdentifier, displayName, artifact.getName(), artifact.getType(), artifact.getExt(), attrs);
            this.artifact = artifact;
            this.file = file;
        }

        public String toString() {
            return this.id.toString();
        }

        public IvyArtifactName getName() {
            return this.id.getName();
        }

        public ComponentIdentifier getComponentId() {
            return this.componentIdentifier;
        }

        public ComponentArtifactIdentifier getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

