/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleVersionNotFoundException
extends ModuleVersionResolveException {
    public ModuleVersionNotFoundException(ModuleVersionSelector selector, String messageFormat) {
        super(selector, messageFormat);
    }

    public ModuleVersionNotFoundException(ModuleVersionSelector selector) {
        super(selector, "Could not find any version that matches %s.");
    }

    public ModuleVersionNotFoundException(ModuleVersionSelector selector, List<String> attemptedLocations) {
        super(selector, ModuleVersionNotFoundException.format("Could not find any version that matches %s.", attemptedLocations));
    }

    public ModuleVersionNotFoundException(ModuleVersionIdentifier id) {
        super(id, "Could not find %s.");
    }

    public ModuleVersionNotFoundException(ModuleVersionIdentifier id, List<String> attemptedLocations) {
        super(id, ModuleVersionNotFoundException.format("Could not find %s.", attemptedLocations));
    }

    private static String format(String messageFormat, List<String> locations) {
        if (locations.isEmpty()) {
            return messageFormat;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(messageFormat);
        builder.append(String.format("%nSearched in the following locations:", new Object[0]));
        for (String location : locations) {
            builder.append(String.format("%n    %s", location.replace("%", "%%")));
        }
        return builder.toString();
    }
}

