/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.model.ComponentResolveMetaData;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentIdResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentIdResolveResult {
    private ModuleVersionResolveException failure;
    private ComponentResolveMetaData metaData;
    private ComponentIdentifier id;
    private ModuleVersionIdentifier moduleVersionId;
    private ComponentSelectionReason selectionReason;

    public boolean hasResult() {
        return this.id != null || this.failure != null;
    }

    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.id;
    }

    public ModuleVersionIdentifier getModuleVersionId() {
        this.assertResolved();
        return this.moduleVersionId;
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    public void setSelectionReason(ComponentSelectionReason reason) {
        this.selectionReason = reason;
    }

    public ComponentResolveMetaData getMetaData() {
        this.assertResolved();
        return this.metaData;
    }

    public void resolved(ComponentIdentifier id, ModuleVersionIdentifier moduleVersionIdentifier) {
        this.reset();
        this.id = id;
        this.moduleVersionId = moduleVersionIdentifier;
    }

    public void resolved(ComponentResolveMetaData metaData) {
        this.resolved(metaData.getComponentId(), metaData.getId());
        this.metaData = metaData;
    }

    public void failed(ModuleVersionResolveException failure) {
        this.reset();
        this.failure = failure;
    }

    public void notFound(ModuleVersionSelector requested) {
        this.failed(new ModuleVersionNotFoundException(requested, this.getAttempted()));
    }

    private void assertResolved() {
        if (this.failure != null) {
            throw this.failure;
        }
        if (this.id == null) {
            throw new IllegalStateException("Not resolved.");
        }
    }

    private void reset() {
        this.failure = null;
        this.metaData = null;
        this.id = null;
        this.moduleVersionId = null;
        this.selectionReason = VersionSelectionReasons.REQUESTED;
    }
}

