/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.Collection;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableModuleComponentVersionSelectionResolveResult;
import org.gradle.internal.resolve.result.DefaultModuleVersionListing;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ModuleVersionListing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildableModuleComponentVersionSelectionResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleComponentVersionSelectionResolveResult {
    private BuildableModuleComponentVersionSelectionResolveResult.State state = BuildableModuleComponentVersionSelectionResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private ModuleVersionListing versions;
    private boolean authoritative;

    private void reset(BuildableModuleComponentVersionSelectionResolveResult.State state) {
        this.state = state;
        this.versions = null;
        this.failure = null;
        this.authoritative = false;
    }

    @Override
    public BuildableModuleComponentVersionSelectionResolveResult.State getState() {
        return this.state;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableModuleComponentVersionSelectionResolveResult.State.Unknown;
    }

    @Override
    public ModuleVersionListing getVersions() throws ModuleVersionResolveException {
        this.assertHasResult();
        return this.versions;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public void listed(ModuleVersionListing versions) {
        this.reset(BuildableModuleComponentVersionSelectionResolveResult.State.Listed);
        this.versions = versions;
        this.authoritative = true;
    }

    @Override
    public void listed(Collection<String> versions) {
        DefaultModuleVersionListing listing = new DefaultModuleVersionListing();
        for (String version : versions) {
            listing.add(version);
        }
        this.listed(listing);
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleComponentVersionSelectionResolveResult.State.Failed);
        this.failure = failure;
        this.authoritative = true;
    }

    @Override
    public boolean isAuthoritative() {
        this.assertHasResult();
        return this.authoritative;
    }

    @Override
    public void setAuthoritative(boolean authoritative) {
        this.assertHasResult();
        this.authoritative = authoritative;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

