/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.internal.resolve.result.ModuleVersionListing;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleVersionListing
implements ModuleVersionListing {
    private final Set<Versioned> versions = new HashSet<Versioned>();

    public DefaultModuleVersionListing(String version) {
        this.add(version);
    }

    public DefaultModuleVersionListing() {
    }

    public void add(String version) {
        this.versions.add(new DefaultAvailableVersion(version));
    }

    @Override
    public Set<Versioned> getVersions() {
        return this.versions;
    }

    public String toString() {
        return CollectionUtils.collect(this.versions, (Transformer)new Transformer<String, Versioned>(){

            public String transform(Versioned original) {
                return original.getVersion();
            }
        }).toString();
    }

    private static class DefaultAvailableVersion
    implements Versioned {
        private final String version;

        public DefaultAvailableVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof DefaultAvailableVersion && this.version.equals(((DefaultAvailableVersion)o).version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public String toString() {
            return String.format("AvailableVersion '%s'", this.version);
        }
    }
}

