/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.LocalFileStandInExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;

public class CachedExternalResourceAdapter
extends LocalFileStandInExternalResource {
    private final LocallyAvailableResource local;
    private final ExternalResourceAccessor accessor;
    private final HashValue expectedChecksum;

    public CachedExternalResourceAdapter(URI source, LocallyAvailableResource local, ExternalResourceAccessor accessor, ExternalResourceMetaData remoteMetaData, HashValue expectedChecksum) {
        super(source, local.getFile(), remoteMetaData);
        this.local = local;
        this.accessor = accessor;
        this.expectedChecksum = expectedChecksum;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.local.getFile());
    }

    public void writeTo(File destination) throws IOException {
        try {
            super.writeTo(destination);
        }
        catch (IOException e) {
            this.downloadResourceDirect(destination);
            return;
        }
        if (!this.getSha1(destination).equals((Object)this.expectedChecksum)) {
            this.downloadResourceDirect(destination);
        }
    }

    private void downloadResourceDirect(File destination) throws IOException {
        this.accessor.getResource(this.getURI()).writeTo(destination);
    }
}

