/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalResourceRepository
implements ExternalResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceRepository.class);
    private final String name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;

    public DefaultExternalResourceRepository(String name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
    }

    @Override
    public ExternalResource getResource(URI source) throws IOException {
        return this.accessor.getResource(source);
    }

    @Override
    public ExternalResourceMetaData getResourceMetaData(URI source) throws IOException {
        return this.accessor.getMetaData(source);
    }

    @Override
    public void put(File source, URI destination) throws IOException {
        this.doPut(source, destination);
        this.putChecksum("SHA1", 40, source, destination);
    }

    private void putChecksum(String algorithm, int checksumlength, File source, URI destination) throws IOException {
        byte[] checksumFile = this.createChecksumFile(source, algorithm, checksumlength);
        URI checksumDestination = URI.create(destination + "." + algorithm.toLowerCase());
        this.doPut(checksumFile, checksumDestination);
    }

    private byte[] createChecksumFile(File src, String algorithm, int checksumlength) {
        HashValue hash = HashUtil.createHash((File)src, (String)algorithm);
        String formattedHashString = this.formatHashString(hash.asHexString(), checksumlength);
        try {
            return formattedHashString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private String formatHashString(String hashKey, int length) {
        while (hashKey.length() < length) {
            hashKey = "0" + hashKey;
        }
        return hashKey;
    }

    private void doPut(final File source, URI destination) throws IOException {
        LOGGER.debug("Attempting to put resource {}.", (Object)destination);
        assert (source.isFile());
        this.uploader.upload((Factory)new Factory<InputStream>(){

            public InputStream create() {
                try {
                    return new FileInputStream(source);
                }
                catch (FileNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }, Long.valueOf(source.length()), destination);
    }

    private void doPut(final byte[] source, URI destination) throws IOException {
        LOGGER.debug("Attempting to put resource {}.", (Object)destination);
        this.uploader.upload((Factory)new Factory<InputStream>(){

            public InputStream create() {
                return new ByteArrayInputStream(source);
            }
        }, Long.valueOf(source.length), destination);
    }

    @Override
    public List<String> list(URI parent) throws IOException {
        return this.lister.list(parent);
    }

    public String toString() {
        return this.name;
    }
}

