/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.DefaultCacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ProgressLoggingExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ProgressLoggingExternalResourceUploader;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;
import org.gradle.internal.resource.transport.DefaultExternalResourceRepository;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.util.BuildCommencedTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransport
extends AbstractRepositoryTransport {
    private final ExternalResourceRepository repository;
    private final DefaultCacheAwareExternalResourceAccessor resourceAccessor;

    public HttpTransport(String name, PasswordCredentials credentials, ProgressLoggerFactory progressLoggerFactory, TemporaryFileProvider temporaryFileProvider, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        super(name);
        HttpClientHelper http = new HttpClientHelper((HttpSettings)new DefaultHttpSettings(credentials));
        HttpResourceAccessor accessor = new HttpResourceAccessor(http);
        HttpResourceUploader uploader = new HttpResourceUploader(http);
        ProgressLoggingExternalResourceAccessor loggingAccessor = new ProgressLoggingExternalResourceAccessor((ExternalResourceAccessor)accessor, progressLoggerFactory);
        this.resourceAccessor = new DefaultCacheAwareExternalResourceAccessor(loggingAccessor, cachedExternalResourceIndex, timeProvider, temporaryFileProvider, cacheLockingManager);
        this.repository = new DefaultExternalResourceRepository(name, (ExternalResourceAccessor)accessor, new ProgressLoggingExternalResourceUploader((ExternalResourceUploader)uploader, progressLoggerFactory), (ExternalResourceLister)new HttpResourceLister(accessor));
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public ExternalResourceRepository getRepository() {
        return this.repository;
    }
}

