/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpException;

public class SftpResource
extends AbstractExternalResource {
    private final SftpClientFactory clientFactory;
    private final ExternalResourceMetaData metaData;
    private final URI uri;
    private final PasswordCredentials credentials;
    private LockableSftpClient client;

    public SftpResource(SftpClientFactory clientFactory, ExternalResourceMetaData metaData, URI uri, PasswordCredentials credentials) {
        this.clientFactory = clientFactory;
        this.metaData = metaData;
        this.uri = uri;
        this.credentials = credentials;
    }

    protected InputStream openStream() throws IOException {
        this.client = this.clientFactory.createSftpClient(this.uri, this.credentials);
        try {
            return this.client.getSftpClient().get(this.uri.getPath());
        }
        catch (com.jcraft.jsch.SftpException e) {
            throw new SftpException(String.format("Could not get resource at '%s'.", this.uri), e);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public long getLastModified() {
        return this.metaData.getLastModified().getTime();
    }

    public long getContentLength() {
        return this.metaData.getContentLength();
    }

    public boolean isLocal() {
        return false;
    }

    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public void close() throws IOException {
        this.clientFactory.releaseSftpClient(this.client);
    }
}

