/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.jcraft.jsch.ChannelSftp;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.gradle.internal.resource.PasswordCredentials;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpClientFactory;
import org.gradle.internal.resource.transport.sftp.SftpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpResourceLister
implements ExternalResourceLister {
    private final SftpClientFactory sftpClientFactory;
    private final PasswordCredentials credentials;

    public SftpResourceLister(SftpClientFactory sftpClientFactory, PasswordCredentials credentials) {
        this.sftpClientFactory = sftpClientFactory;
        this.credentials = credentials;
    }

    public List<String> list(URI parent) throws IOException {
        LockableSftpClient client = this.sftpClientFactory.createSftpClient(parent, this.credentials);
        try {
            Vector entries = client.getSftpClient().ls(parent.getPath());
            ArrayList<String> list = new ArrayList<String>();
            for (ChannelSftp.LsEntry entry : entries) {
                list.add(entry.getFilename());
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (com.jcraft.jsch.SftpException e) {
            if (e.id == 2) {
                List<String> list = null;
                return list;
            }
            throw new SftpException(String.format("Could not list children for resource '%s'.", parent), e);
        }
        finally {
            this.sftpClientFactory.releaseSftpClient(client);
        }
    }
}

