/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import java.util.List;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.internal.rules.RuleActionValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRuleActionValidator<T>
implements RuleActionValidator<T> {
    private static final String UNSUPPORTED_PARAMETER_TYPE_ERROR = "Unsupported parameter type: %s";
    private final List<Class<?>> validInputTypes;

    public DefaultRuleActionValidator(List<Class<?>> validInputTypes) {
        this.validInputTypes = validInputTypes;
    }

    @Override
    public RuleAction<? super T> validate(RuleAction<? super T> ruleAction) {
        this.validateInputTypes(ruleAction);
        return ruleAction;
    }

    private void validateInputTypes(RuleAction<? super T> ruleAction) {
        for (Class<?> inputType : ruleAction.getInputTypes()) {
            if (this.validInputTypes.contains(inputType)) continue;
            throw new RuleActionValidationException(String.format(UNSUPPORTED_PARAMETER_TYPE_ERROR, inputType.getName()));
        }
    }
}

