/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.rules.RuleAction;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Mutate;
import org.gradle.model.internal.core.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSourceBackedRuleAction<R, T>
implements RuleAction<T> {
    private final R instance;
    private final JavaMethod<R, T> ruleMethod;

    private RuleSourceBackedRuleAction(R instance, JavaMethod<R, T> ruleMethod) {
        this.instance = instance;
        this.ruleMethod = ruleMethod;
    }

    public static <R, T> RuleSourceBackedRuleAction<R, T> create(ModelType<T> subjectType, R ruleSourceInstance) {
        ModelType ruleSourceType = ModelType.typeOf(ruleSourceInstance);
        List mutateMethods = JavaReflectionUtil.findAllMethods((Class)ruleSourceType.getConcreteClass(), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                return element.isAnnotationPresent(Mutate.class);
            }
        });
        if (mutateMethods.size() != 1) {
            throw RuleSourceBackedRuleAction.invalid(ruleSourceType, "must have at exactly one method annotated with @Mutate");
        }
        Method ruleMethod = (Method)mutateMethods.get(0);
        if (ruleMethod.getReturnType() != Void.TYPE) {
            throw RuleSourceBackedRuleAction.invalid(ruleSourceType, "rule method must return void");
        }
        Type[] parameterTypes = ruleMethod.getGenericParameterTypes();
        if (parameterTypes.length == 0) {
            throw RuleSourceBackedRuleAction.invalid(ruleSourceType, "rule method must have at least one parameter");
        }
        if (!subjectType.isAssignableFrom(ModelType.of((Type)parameterTypes[0]))) {
            throw RuleSourceBackedRuleAction.invalid(ruleSourceType, String.format("first parameter of rule method must be of type %s", subjectType));
        }
        return new RuleSourceBackedRuleAction<R, T>(ruleSourceInstance, new JavaMethod(ruleSourceType.getConcreteClass(), subjectType.getConcreteClass(), ruleMethod));
    }

    private static RuntimeException invalid(ModelType<?> source, String reason) {
        return new InvalidModelRuleDeclarationException("Type " + source + " is not a valid model rule source: " + reason);
    }

    @Override
    public List<Class<?>> getInputTypes() {
        Class[] parameterTypes = this.ruleMethod.getParameterTypes();
        return Arrays.asList(parameterTypes).subList(1, parameterTypes.length);
    }

    @Override
    public void execute(T subject, List<?> inputs) {
        ArrayList args = Lists.newArrayList();
        args.add(subject);
        args.addAll(inputs);
        this.ruleMethod.invoke(this.instance, args.toArray());
    }
}

