/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.lifecycle.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.mvn3.org.apache.maven.execution.MavenSession;
import org.gradle.mvn3.org.apache.maven.execution.ProjectDependencyGraph;
import org.gradle.mvn3.org.apache.maven.lifecycle.MavenExecutionPlan;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.BuilderCommon;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.gradle.mvn3.org.apache.maven.lifecycle.internal.ProjectSegment;
import org.gradle.mvn3.org.apache.maven.plugin.MojoExecution;
import org.gradle.mvn3.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.Logger;
import org.gradle.mvn3.org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleDebugLogger.class)
public class LifecycleDebugLogger {
    @Requirement
    private Logger logger;

    public LifecycleDebugLogger() {
    }

    public LifecycleDebugLogger(Logger logger) {
        this.logger = logger;
    }

    public void debug(String s) {
        this.logger.debug(s);
    }

    public void info(String s) {
        this.logger.info(s);
    }

    public void debugReactorPlan(ProjectBuildList projectBuilds) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== REACTOR BUILD PLAN ================================================");
        Iterator<ProjectSegment> it = projectBuilds.iterator();
        while (it.hasNext()) {
            ProjectSegment projectBuild = it.next();
            this.logger.debug("Project: " + projectBuild.getProject().getId());
            this.logger.debug("Tasks:   " + projectBuild.getTaskSegment().getTasks());
            this.logger.debug("Style:   " + (projectBuild.getTaskSegment().isAggregating() ? "Aggregating" : "Regular"));
            if (!it.hasNext()) continue;
            this.logger.debug("-----------------------------------------------------------------------");
        }
        this.logger.debug("=======================================================================");
    }

    public void debugProjectPlan(MavenProject currentProject, MavenExecutionPlan executionPlan) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== PROJECT BUILD PLAN ================================================");
        this.logger.debug("Project:       " + BuilderCommon.getKey(currentProject));
        this.debugDependencyRequirements(executionPlan.getMojoExecutions());
        this.logger.debug("Repositories (dependencies): " + currentProject.getRemoteProjectRepositories());
        this.logger.debug("Repositories (plugins)     : " + currentProject.getRemotePluginRepositories());
        for (ExecutionPlanItem mojoExecution : executionPlan) {
            this.debugMojoExecution(mojoExecution.getMojoExecution());
        }
        this.logger.debug("=======================================================================");
    }

    private void debugMojoExecution(MojoExecution mojoExecution) {
        String mojoExecId = mojoExecution.getGroupId() + ':' + mojoExecution.getArtifactId() + ':' + mojoExecution.getVersion() + ':' + mojoExecution.getGoal() + " (" + mojoExecution.getExecutionId() + ')';
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                this.logger.debug("--- init fork of " + fork.getKey() + " for " + mojoExecId + " ---");
                this.debugDependencyRequirements(fork.getValue());
                for (MojoExecution forkedExecution : fork.getValue()) {
                    this.debugMojoExecution(forkedExecution);
                }
                this.logger.debug("--- exit fork of " + fork.getKey() + " for " + mojoExecId + " ---");
            }
        }
        this.logger.debug("-----------------------------------------------------------------------");
        this.logger.debug("Goal:          " + mojoExecId);
        this.logger.debug("Style:         " + (mojoExecution.getMojoDescriptor().isAggregator() ? "Aggregating" : "Regular"));
        this.logger.debug("Configuration: " + mojoExecution.getConfiguration());
    }

    private void debugDependencyRequirements(List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            String scopeToResolve;
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
            if (StringUtils.isNotEmpty((String)scopeToCollect)) {
                scopesToCollect.add(scopeToCollect);
            }
            if (!StringUtils.isNotEmpty((String)(scopeToResolve = mojoDescriptor.getDependencyResolutionRequired()))) continue;
            scopesToResolve.add(scopeToResolve);
        }
        this.logger.debug("Dependencies (collect): " + scopesToCollect);
        this.logger.debug("Dependencies (resolve): " + scopesToResolve);
    }

    public void logWeavePlan(MavenSession session) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        ProjectDependencyGraph dependencyGraph = session.getProjectDependencyGraph();
        this.logger.info("=== WEAVE CONCURRENCY BUILD PLAN ======================================");
        for (MavenProject mavenProject : dependencyGraph.getSortedProjects()) {
            StringBuilder item = new StringBuilder();
            item.append("Project: ");
            item.append(mavenProject.getArtifactId());
            List<MavenProject> upstreamProjects = dependencyGraph.getUpstreamProjects(mavenProject, false);
            if (upstreamProjects.size() > 0) {
                item.append(" ( ");
                Iterator<MavenProject> it = upstreamProjects.iterator();
                while (it.hasNext()) {
                    MavenProject kid = it.next();
                    item.append(kid.getArtifactId());
                    if (!it.hasNext()) continue;
                    item.append(", ");
                }
                item.append(")");
            }
            this.logger.info(item.toString());
        }
        this.logger.info("=======================================================================");
    }
}

