/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.lifecycle.internal;

import java.util.HashMap;
import org.gradle.mvn3.org.apache.maven.execution.MavenSession;
import org.gradle.mvn3.org.apache.maven.model.Plugin;
import org.gradle.mvn3.org.apache.maven.model.PluginManagement;
import org.gradle.mvn3.org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.gradle.mvn3.org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.gradle.mvn3.org.apache.maven.plugin.version.PluginVersionResolver;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecyclePluginResolver.class)
public class LifecyclePluginResolver {
    @Requirement
    private PluginVersionResolver pluginVersionResolver;

    public LifecyclePluginResolver(PluginVersionResolver pluginVersionResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
    }

    public LifecyclePluginResolver() {
    }

    public void resolveMissingPluginVersions(MavenProject project, MavenSession session) throws PluginVersionResolutionException {
        HashMap<String, String> versions = new HashMap<String, String>(64);
        for (Plugin plugin : project.getBuildPlugins()) {
            if (plugin.getVersion() == null) {
                DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
                plugin.setVersion(this.pluginVersionResolver.resolve(request).getVersion());
            }
            versions.put(plugin.getKey(), plugin.getVersion());
        }
        PluginManagement pluginManagement = project.getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (plugin.getVersion() != null) continue;
                plugin.setVersion((String)versions.get(plugin.getKey()));
                if (plugin.getVersion() != null) continue;
                DefaultPluginVersionRequest request = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
                plugin.setVersion(this.pluginVersionResolver.resolve(request).getVersion());
            }
        }
    }
}

